﻿/**
 *	related synchronize module.
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module os.i386.sync;

import std.stdint;

struct AtomicInteger {
	
	uint32_t opPostInc() {return value_++;}
	uint32_t opPostDec() {return value_--;}
	void opAddAssign(uint32_t x) {value_ += x;}
	void opSubAssign(uint32_t x) {value_ -= x;}
	void opMulAssign(uint32_t x) {value_ *= x;}
	void opDivAssign(uint32_t x) {value_ /= x;}
	
	uint32_t value() {return value_;}
	void value(uint32_t x) {value_ = x;}
	
	private uint32_t value_;
}

/// get time stamp counter.
ulong getTSC() {
	asm {
		naked;
		rdtsc;
		ret;
	}
}

/// wait clock cycles.
void wait(uint32_t n) {
	ulong begin = getTSC();
	do {
		asm {rep; nop;}
	} while((getTSC() - begin) < n);
}
