/**
 *	basic C string functions.
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module std.c.string;

extern (C):

void* memcpy(void* s1, void* s2, size_t n) {
	for(size_t i = 0; i < n; ++i) {
		(cast(ubyte*)s1)[i] = (cast(ubyte*)s2)[i];
	}
	return s1;
}

void* memset(void* buf, int ch, size_t n) {
	for(size_t i = 0; i < n; ++i) {
		(cast(ubyte*)buf)[i] = cast(ubyte) ch;
	}
	return buf;
}

void* memmove(void* s1, void* s2, size_t n) {
	if((s1 < s2) | (s2 + n < s1)) {
		// not overlap.
		for(size_t i = 0; i < n; ++i) {
			(cast(ubyte*)s1)[i] = (cast(ubyte*)s2)[i];
		}
	} else {
		// reverse copy.
		for(size_t i = 0; i < n; ++i) {
			(cast(ubyte*)s1)[n - i - 1] = (cast(ubyte*)s2)[n - i - 1];
		}
	}
	return s1;
}

int memcmp(void* s1, void* s2, size_t n) {
	for(size_t i = 0; i < n; ++i) {
		int result = (cast(ubyte*)s1)[i] - (cast(ubyte*)s2)[i];
		if(result) {
			return result;
		}
	}
	return 0;
}

size_t strlen(char* s) {
	char* p = s;
	while(*p) ++p;
	return p - s;
}
