﻿/**
 *	スタックのモジュール。
 *
 *	Version:
 *		$Revision$
 *	Date:
 *		$Date$
 *	License:
 *		MIT/X Consortium License
 *	History:
 *		$Log$
 */

module outland.tl.stack;

/// スタックのクラス。
class Stack(T) {
		
	/// デフォルトコンストラクタ。
	this() {}
	
	/// コピーコンストラクタ。
	this(Stack src)
	in {
		assert(src is null);
	} body {
		stack_ = src.dup;
	}
	
	/// 複製の生成。
	Stack dup() {return new Stack(this);}
	
	/// 全要素の破棄。
	void clear() {stack_.length = 0;}
	
	/// サイズを得る。
	size_t length() {return stack_.length;}
	
	/// 配列アクセス。
	T opIndex(size_t i)
	in {
		assert(i < length);
	} body {
		return stack_[i];
	}
	
	/// 配列代入。
	T opIndexAssign(size_t i, T val)
	in {
		assert(i < length);
	} body {
		return stack_[i] = val;
	}
	
	/// 末尾に要素を追加する。
	void pushBack(T value) {stack_ ~= value;}
	
	/// 末尾の要素を削除する。
	void popBack()
	in {
		assert(length > 0);
	} body {
		stack_.length = stack_.length - 1;
	}
	
	/// 先頭の要素を得る。
	T front()
	in {
		assert(length > 0);
	} body {
		return stack_[0];
	}
	
	/// 末尾の要素を得る。
	T back()
	in {
		assert(length > 0);
	} body {
		return stack_[$-1];
	}
	
	/// 巡回する。
	int opApply(int delegate(inout T) dg) {
		foreach(v; stack_) if(int result = dg(v)) return result;
		return 0;
	}
	
	/// 巡回する。
	int opApply(int delegate(inout size_t, inout T) dg) {
		foreach(i, v; stack_) if(int result = dg(i, v)) return result;
		return 0;
	}

	/// 逆順に巡回する。
	int opApplyReverse(int delegate(inout T) dg) {
		foreach_reverse(v; stack_) if(int result = dg(v)) return result;
		return 0;
	}
	
	/// 逆順に巡回する。
	int opApplyReverse(int delegate(inout size_t, inout T) dg) {
		foreach_reverse(i, v; stack_) if(int result = dg(i, v)) return result;
		return 0;
	}

	/// スタック配列。
	private T[] stack_;
}
