﻿module outland.widget.application;

import outland.widget.error;
import outland.widget.event;
import outland.widget.graphics;
import outland.widget.shape;
import outland.widget.widget;

/// アプリケーションのインターフェイス。
interface IApplication {
	
	/// イベントコード。
	enum : EventCode {
		SYSTEM_IDLE = USER_CODE_BEGIN,
		SYSTEM_QUERY_QUIT,
		SYSTEM_QUIT,
		
		/// イベントコード終点。
		EVENT_CODE_END,
	}
	
	/**	メインループを回す。
	 *	Returns:
	 *		アプリケーションが続行されるかどうか。
	 */
	bool continueMainLoop();
	
	/// メインループの実行。
	int run();
	
	/// 終了指示。(即座には終了しない)
	void quit(int code);
	
	/// フレーム生成。
	IFrame makeFrame(Rect rect);
	
	/// グラフィックス生成。
	IGraphics makeGraphics(Size size);
	
	/// コマンドライン文字列。
	char[][] arguments();
	
	/// エラーメッセージの表示。
	void errorMessage(char[] msg);
	
	/// 警告メッセージの表示。
	void warningMessage(char[] msg);
	
	/// 情報メッセージの表示。
	void infoMessage(char[] msg);
}

/// アプリケーションを返す。
IApplication getApplication() {return globalApplicationObject;}

/// アプリケーションオブジェクト。
private IApplication globalApplicationObject;

version(Win32) {
	// Win32環境でのアプリケーション生成。
	import outland.widget.win32.application;
	
	/// アプリケーション基本クラス。
	private alias WinApplication ApplicationBase;
}

/// ネイティブなアプリケーションクラス。
class Application : ApplicationBase {
	/// コマンドライン文字列を指定して生成する。
	this(char[][] args) {
		super(args);
		synchronized(Application.classinfo) {
			if(globalApplicationObject !is null) throw new WidgetException("Application is already exists!");
			// アプリケーションを登録。
			globalApplicationObject = this;
		}
	}
}
