﻿module outland.widget.error;

/// ウィジェット関連エラー。
class WidgetException : Exception {	
	/// メッセージを指定して生成する。
	this(char[] msg) {super(msg);}
}

/// 非サポート例外。
class NotSupportedException : WidgetException {
	/// デフォルトコンストラクタ。
	this(char[] msg = "Not supported operation!") {super(msg);}
}

/// 不正引数例外。
class InvalidArgumentException : WidgetException {
	/// デフォルトコンストラクタ。
	this(char[] msg = "Invalid arugment!") {super(msg);}
}
