﻿module outland.widget.label;

import outland.tl.algorithm;

import outland.widget.event;
import outland.widget.graphics;
import outland.widget.shape;
import outland.widget.widget;

/// ラベルクラス。
class Label : Control {
	
	/// 文字位置。
	enum AlignH {
		LEFT,
		CENTER,
		RIGHT,
	}
	
	/// ditto
	enum AlignV {
		TOP,
		MIDDLE,
		BOTTOM,
	}
	
	/// デフォルトコンストラクタ。
	this() {}
	
	/// キャプションを指定して生成する。
	this(char[] text) {text_ = text;}
	
	/// 描画。
	void draw(IGraphics g)
	in {
		assert(g !is null);
	} body {
		auto r = Rect(Point(0, 0), this.size);
		
		// 背景の塗りつぶし。
		if(back_ != Color.INVALID) {
			g.fillColor = back_;
			g.colorFill(r);
		}
		
		g.textColor = color_;
		g.font = font_;
		
		auto s = g.getTextSize(text_);
		Point pos = r.position;
		
		// 水平配置。
		switch(alignH_) {
		default: case AlignH.LEFT:
			break;
		case AlignH.CENTER:
			pos.x = ((r.width - s.width) + 1) / 2;
			break;
		case AlignH.RIGHT:
			pos.x = r.width - s.width;
			break;
		}
		
		// 垂直配置。
		switch(alignV_) {
		default: case AlignV.TOP:
			break;
		case AlignV.MIDDLE:
			pos.y = ((r.height - s.height) + 1) / 2;
			break;
		case AlignV.BOTTOM:
			pos.y = r.height - s.height;
			break;
		}
		
		g.text(pos, text_);
	}
	
	/// 背景色。Color.INVALIDの場合は透過。
	Color backColor() {return back_;}
	
	/// ditto
	void backColor(Color c) {
		back_ = c;
		update();
	}
	
	/// テキスト色。
	Color textColor() {return color_;}
	
	/// ditto
	void textColor(Color c) {
		color_ = c;
		update();
	}
	
	/// テキスト。
	char[] text() {return text_;}
	
	/// ditto
	void text(char[] t) {
		text_ = t;
		update();
	}
	
	/// フォント。
	Font font() {return font_;}
	
	/// ditto
	void font(Font f) {
		font_ = f;
		update();
	}
	
	/// 文字位置。
	AlignH alignH() {return alignH_;}
	
	/// ditto
	void alignH(AlignH a) {
		alignH_ = a;
		update();
	}
	
	/// ditto
	AlignV alignV() {return alignV_;}
	
	/// ditto
	void alignV(AlignV a) {
		alignV_ = a;
		update();
	}
	
private:
	
	/// フォント。
	Font font_;
	
	/// 背景色。
	Color back_ = {red:255, green:255, blue:255};
	
	/// テキスト色。
	Color color_ = {red:0, green:0, blue:0};
	
	/// テキスト。
	char[] text_;
	
	/// 水平文字位置。
	AlignH alignH_ = AlignH.LEFT;
	
	/// 垂直文字位置。
	AlignV alignV_ = AlignV.TOP;
}
