﻿module outlandkarasu.widget.layout;

import outlandkarasu.widget.widget;
import outlandkarasu.widget.shape;

/// フローレイアウト。
class FlowLayout : ILayoutStrategy {
	
	/// デフォルトコンストラクタ。
	this() {}
	
	/// 水平・垂直間隔を指定して生成する。
	this(int h, int v) {
		gapH_ = h;
		gapV_ = v;
	}
	
	/// 使用しない。
	void add(IWidget item, Object hint) {}
	
	/// ditto
	void remove(IWidget item) {}
	
	/// ditto
	void clear() {}
	
	/// レイアウトを実行する。
	void layout(IContainer cont)
	in {
		assert(cont !is null);
	} body {
		// レイアウト幅。
		int width = cont.size.width;
		
		// 行の高さ。
		int height = 0;
		
		// 行内での位置。
		size_t index = 0;
		
		// 現在位置。
		Point pos;
		
		foreach(c; cont) {
			// 項目がレイアウト幅を超える場合は改行。
			// 行頭の項目だった場合はとにかく入れてしまう。
			if(index > 0 && width < (pos.x + c.size.width)) {
				// 行の高さ + ギャップ。
				pos.y = pos.y + height + gapV_;
				pos.x = 0;
				index = 0;
				height = 0;
			}
			
			// 移動。
			c.position = pos;
			
			// 次の位置。
			// 項目の幅 + ギャップ。
			pos.x = pos.x + c.size.width + gapH_;
			
			// 項目の最大高さを行の高さにする。
			if(height < c.size.height) height = c.size.height;
			++index;
		}
	}
	
	/// 最小サイズ。
	Size minimumSize(IContainer cont)
	in {
		assert(cont !is null);
	} body {
		return calculateOneLineSize(cont, (IWidget c) {return c.minimumSize;});
	}
	
	/// 推奨サイズ。
	Size preferredSize(IContainer cont)
	in {
		assert(cont !is null);
	} body {
		return calculateOneLineSize(cont, (IWidget c) {return c.preferredSize;});
	}
	
	/// 最大サイズ。
	Size maximumSize(IContainer cont)
	in {
		assert(cont !is null);
	} body {
		return calculateOneLineSize(cont, (IWidget c) {return c.maximumSize;});
	}
	
	/// 水平ギャップ。
	int gapH() {return gapH_;}
	
	/// ditto
	void gapH(int h) {gapH_ = h;}
	
	/// 垂直ギャップ。
	int gapV() {return gapV_;}
	
	/// ditto
	void gapV(int v) {gapV_ = v;}
	
private:
	
	/// 1行のときのサイズを求める。
	Size calculateOneLineSize(IContainer cont, Size delegate(IWidget) dg) {
		Size result;
		foreach(c; cont) {
			result.width = result.width + dg(c).width + gapH_;
			if(result.height < dg(c).height) result.height = dg(c).height;
		}
		result.width = result.width - gapH_;
		return result;
	}
	
	/// 水平ギャップ。
	int gapH_;
	
	/// 垂直ギャップ。
	int gapV_;
}
