﻿module outlandkarasu.widget.mouse;

import outlandkarasu.widget.event;
import outlandkarasu.widget.shape;

/// マウス状態。
typedef uint MouseState;

/// ditto
enum : MouseState {
	MOUSE_NONE,
	MOUSE_SHIFT = cast(MouseState) 0b0001U,
	MOUSE_ALT = cast(MouseState) 0b0010U,
	MOUSE_CTRL = cast(MouseState) 0b0100U,
	
	MOUSE_BUTTON1 = cast(MouseState) 0b000001_0000U,
	MOUSE_BUTTON2 = cast(MouseState) 0b000010_0000U,
	MOUSE_BUTTON3 = cast(MouseState) 0b000100_0000U,
	MOUSE_BUTTON4 = cast(MouseState) 0b001000_0000U,
	MOUSE_BUTTON5 = cast(MouseState) 0b010000_0000U,
	MOUSE_BUTTON6 = cast(MouseState) 0b100000_0000U,
	
	/// マウスボタンの状態を表すマスク。
	MOUSE_BUTTON_MASK = cast(MouseState) ~0b1111U,
}

/// マウスイベント基本クラス。
abstract class MouseEvent : Event {
	/// 生成する。
	this(EventId id, EventCode code) {super(id, code);}
}

/// マウスキャプチャイベント。
class MouseCaptureEvent : MouseEvent {
	/**	キャプチャの移動するウィジェットを指定して生成する。
	 *	Params:
	 *		prev	= キャプチャを保持していたウィジェット。
	 *		next	= 次にキャプチャを得るウィジェット。
	 */
	this(IWidget prev, IWidget next) {
		super(EVENT_ID_USER, EVENT_CODE_MOUSE_CAPTURE);
	}
}

/// マウスリリースイベント。
class MouseReleaseEvent : MouseEvent {
	/**	キャプチャの移動するウィジェットを指定して生成する。
	 *	Params:
	 *		prev	= キャプチャを保持していたウィジェット。
	 *		next	= 次にキャプチャを得るウィジェット。
	 */
	this(IWidget prev, IWidget next) {
		super(EVENT_ID_USER, EVENT_CODE_MOUSE_RELEASE);
	}
}


/// マウス操作イベント基本クラス。
abstract class MouseOperationEvent : MouseEvent {
	/**	位置とマウス状態を指定して生成する。
	 *	Params:
	 *		code	= イベントコード。
	 *		pos		= 位置。
	 *		state	= マウス状態。
	 */
	this(EventCode code, Point pos, MouseState state) {
		super(EVENT_ID_USER, code);
		this.position = pos;
		this.state = state;
	}
	
	/// 位置。
	Point position;
	
	/// マウス状態。
	final MouseState state;
}

/// マウス移動イベント。
class MouseMoveEvent : MouseOperationEvent {
	/// 生成する。
	this(Point pos, MouseState state) {super(EVENT_CODE_MOUSE_MOVE, pos, state);}
}

/// マウス押下イベント。
class MouseDownEvent : MouseOperationEvent {
	/// 生成する。
	this(Point pos, MouseState btn, MouseState state) {
		super(EVENT_CODE_MOUSE_DOWN, pos, state);
		button = btn;
	}
	
	/// 状態が変化したボタン。
	final MouseState button;
}

/// マウス押上イベント。
class MouseUpEvent : MouseOperationEvent {
	/// 生成する。
	this(Point pos, MouseState btn, MouseState state) {
		super(EVENT_CODE_MOUSE_UP, pos, state);
		button = btn;
	}
	
	/// 状態が変化したボタン。
	final MouseState button;
}

/// マウスダブルクリックイベント。
class MouseDoubleClickEvent : MouseOperationEvent {
	/// 生成する。
	this(Point pos, MouseState btn, MouseState state) {
		super(EVENT_CODE_MOUSE_DOUBLE_CLICK, pos, state);
		button = btn;
	}
	
	/// 状態が変化したボタン。
	final MouseState button;
}

/// マウスホイールクリックイベント。
class MouseWheelEvent : MouseOperationEvent {
	/// 生成する。
	this(Point pos, MouseState state, int delta) {
		super(EVENT_CODE_MOUSE_WHEEL, pos, state);
		this.delta = delta;
	}
	
	/// 移動量。
	final int delta;
}
