﻿module outland.widget.win32.application;

import win32.windows;

import outland.widget.application;
import outland.widget.graphics;
import outland.widget.shape;
import outland.widget.widget;

import outland.widget.win32.error;
import outland.widget.win32.frame;
import outland.widget.win32.graphics;
import outland.widget.win32.string;

/// Win32アプリケーションのインターフェイス。
class WinApplication : IApplication {
	
	/// コマンドライン文字列を指定して生成する。
	this(char[][] args) {args_ = args;}
	
	/// メインループの実行。
	int run() {
		while(continueMainLoop()) {}
		return exitCode_;
	}
	
	/**	メインループを回す。
	 *	Returns:
	 *		アプリケーションが続行されるかどうか。
	 */
	bool continueMainLoop() {
		// メッセージ取得。
		MSG msg = void;
		int result = GetMessage(&msg, null, 0, 0);
		if(result == 0) {
			// アプリケーション終了。
			exitCode_ = msg.wParam;
			return false;
		} else if(result == -1) {
			// エラー発生。
			throw new Win32Exception;
		}
		
		// 通常のメッセージ。
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		
		return true;
	}
	
	/// 終了指示。(即座には終了しない)
	void quit(int code) {PostQuitMessage(code);}
	
	/// フレーム生成。
	IFrame makeFrame(Rect rect) {return new WinFrame(rect);}
	
	/// グラフィックス生成。
	IGraphics makeGraphics(Size size) {return null;}
	
	/// コマンドライン文字列。
	char[][] arguments() {return args_;}
	
	/// エラーメッセージの表示。
	void errorMessage(char[] msg) {
		MessageBox(null, toTString(msg), "", MB_OK | MB_ICONERROR);
	}
	
	/// 警告メッセージの表示。
	void warningMessage(char[] msg) {
		MessageBox(null, toTString(msg), "", MB_OK | MB_ICONWARNING);
	}
	
	/// 情報メッセージの表示。
	void infoMessage(char[] msg) {
		MessageBox(null, toTString(msg), "", MB_OK | MB_ICONINFORMATION);
	}
	
private:
	
	/// 終了コード。
	int exitCode_;
	
	/// コマンドライン文字列。
	char[][] args_;
}
