﻿module outland.widget.win32.error;

import win32.windows;

import outland.widget.error;

import outland.widget.win32.string;

/// ウィジェット関連エラー。
class Win32Exception : WidgetException {
	
	/// デフォルトコンストラクタ。
	this() {this(GetLastError());}
	
	/// エラーコードを指定して生成する。
	this(DWORD err) {
		super("");
		code = err;
	}
	
	/// メッセージを取り出す。
	char[] toString() {
		LPTSTR buffer;
		DWORD r = FormatMessage(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
		    null,
		    code,
		    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		    cast(LPTSTR) &buffer,
		    0,
		    null);
		if(r == 0 && !buffer) return "win32 internal error!";
		scope(exit) LocalFree(cast(HLOCAL)buffer);
		
		// Remove \r\n from error string
		if(r >= 2) buffer[r - 2] = cast(TCHAR) '\0';
		return fromTString(buffer);
	}
	
	/// エラーコード。
	final DWORD code;
}
