﻿module sample;

import std.stdio;

import outlandkarasu.widget.all;

int main(char[][] args) {
	IApplication app = new Application(args);
	IFrame frame = app.makeFrame(Rect(Point(0, 0), Size(300, 300)));
	frame.title = "test";
	frame.visible = true;
	frame.quitOnClose = true;
	
	auto c = new Container;
	c.size = Size(100, 100);
	c.visible = true;
	frame.add(c);
	
	auto label = new Label;
	label.text = "";
	label.backColor = Color(0, 0, 0);
	label.textColor = Color(255, 255, 255);
	label.position = Point(0, 0);
	label.size = Size(60, 60);
	label.visible = true;
	label.alignH = Label.AlignH.RIGHT;
	label.alignV = Label.AlignV.MIDDLE;
	label.addHandlerAny(EVENT_CODE_MOUSE_DOWN, (MouseDownEvent e) {getApplication().quit(0);});
	c.add(label);
	
	label = new Label;
	label.text = "";
	label.backColor = Color(255, 255, 255);
	label.textColor = Color(0, 0, 0);
	label.position = Point(60, 0);
	label.size = Size(60, 20);
	label.visible = true;
	c.add(label);
	c.layoutStrategy = new FlowLayout;
	c.pack();

	try {
		return app.run();
	} catch(Object o) {
		app.errorMessage(o.toString());
	}
	return -1;
}
