/***********************************************************************\
*                               windows.d                               *
*                                                                       *
*                       Windows API header module                       *
*                                                                       *
*                 Translated from MinGW Windows headers                 *
*                                                                       *
*                       Placed into public domain                       *
\***********************************************************************/
module win32.windows;

/*
	windows.h - main header file for the Win32 API

	Written by Anders Norlander <anorland@hem2.passagen.se>

	This file is part of a free library for the Win32 API.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

*/

public import win32.w32api;
public import win32.core;

// We can't use static if for imports, build gets confused.
// static if (_WIN32_WINNT_ONLY) import win32.winsvc;
version (Windows2003) {
	public import win32.winsvc;
} else version (WindowsXP) {
	public import win32.winsvc;
} else version (WindowsNTonly) {
	public import win32.winsvc;
}

public import win32.cderr;
public import win32.dde;
public import win32.ddeml;
public import win32.dlgs;
public import win32.imm;
public import win32.lzexpand;
public import win32.mmsystem;
public import win32.nb30;
//public import win32.rpc;
public import win32.shellapi;
public import win32.winperf;
public import win32.commdlg;
public import win32.winspool;
public import win32.ole2;

// Select correct version of winsock.  Importing the incorrect
// module will cause a static assert to prevent problems later on.
version (Win32_Winsock2)
	public import win32.winsock2;
else
	public import win32.winsock;

/+
#if (_WIN32_WINNT >= 0x0400)
#include <winsock2.h>
/*
 * MS likes to include mswsock.h here as well,
 * but that can cause undefined symbols if
 * winsock2.h is included before windows.h
 */
#else
#include <winsock.h>
#endif /*  (_WIN32_WINNT >= 0x0400) */
+/

