#pragma once

#include <hpllib/general/HPLCounter.h>

static const int DEFAULT_ENKO_N_WALK_PERCENTAGE = 50;
static const int DEFAULT_ADD_TIRED = 1;
static const int DEFAULT_BORED_PERCENTAGE = 50;

static const int DEFAULT_WALK_COUNT = 50;

/** Enko̍sp^[̎
  * ړIƂsĂ邩
  * GAttackTypeɗގ
  */
namespace AIPattern {
	enum AIPattern {
		NEUTRAL,	//! ȂBԁip[^ɂAlq͈قȂj
		//! Ă̂ԂƐĥŁAX
		N_WALK,		//! ʏ펞̖ړIړ
		SLEEP,		//! xbh܂͏ŐQ
		ESCAPE,	//! 
		EAT,	//! H
		REST,		//! xbh܂͏ɍ(xe)
		PLAY,	//! ėV
		MAX_NUM
	};
}

/** 
  * Neutralp
  */
class GAINeutral {
public:
	//! ̈ړ܂ł̎
	HPLCounter m_cntWaitForNextMove;
	//! {Ɉړ邩100
	int m_nMovePercentage;
	//! XɔJ܂C^[o
	HPLCounter m_cntAddTiredInterval;
	//! C^[oƂɂ܂
	int m_nAddTired;

	//! тԊu
	HPLCounter m_cntBored;
	int m_nBoredPercentage;
public:
	GAINeutral() {
		const int BORED_COUNT = 100;
		this->m_cntBored.setWaitFrameNum( BORED_COUNT );
		this->m_nBoredPercentage = DEFAULT_BORED_PERCENTAGE;

		const int WAIT_FOR_NEXT_MOVE = 300;
		this->m_cntWaitForNextMove.setWaitFrameNum(
			WAIT_FOR_NEXT_MOVE);
		this->m_nMovePercentage = DEFAULT_ENKO_N_WALK_PERCENTAGE;
		const int ADD_TIRED_INTERVAL = 50;
		this->m_cntAddTiredInterval.setWaitFrameNum( ADD_TIRED_INTERVAL );
		this->m_nAddTired = DEFAULT_ADD_TIRED;
	}
	~GAINeutral(){}
public:
	void reset() {
		this->m_cntWaitForNextMove.reset();
		this->m_nMovePercentage = DEFAULT_ENKO_N_WALK_PERCENTAGE;
		this->m_cntAddTiredInterval.reset();
		this->m_nAddTired = DEFAULT_ADD_TIRED;
		this->m_cntBored.reset();
		this->m_nBoredPercentage = DEFAULT_BORED_PERCENTAGE;
	}
};

/** AIsp
  */
class GAIInfo {
public:
	GAINeutral m_Neutral;

	/////////// N_Walkp
	//! 
	HPLCounter m_cntWalkCount;

	/////////// Escapep
	HPLCounter m_cntCheckInterval;
private:
	//! ̂Ƃlčs
	//! KvȂzɂł邩HiX^bN`
	queue<int> m_qNextAIPatterns;
	//! sp^[
	int m_nAIPattern;
public:
	int getAIPattern() { return this->m_nAIPattern;}
	void setAIPattern( int nPattern ) {
		if( this->m_nAIPattern != nPattern ) {
			switch( this->m_nAIPattern ) {
			case AIPattern::NEUTRAL:
				this->m_Neutral.reset();
				break;
			case AIPattern::N_WALK:
				this->m_cntWalkCount.reset();
				break;
			}
		}
		this->m_nAIPattern = nPattern;
	}
	void clearNextAIPatterns() {
		// g̓v~eBuȂ̂Ŗż
		this->m_qNextAIPatterns = queue<int>();
	}
	void addNextAIPattern( int nAI ) {
		this->m_qNextAIPatterns.push( nAI );
	}
	/** AIp^[𓾂
	  * @retval	-1	ꍇ
	  */
	int getNextAIPattern() {
		if( this->m_qNextAIPatterns.size() > 0 ) {
			int nAI = this->m_qNextAIPatterns.front();
			// pop
			this->m_qNextAIPatterns.pop();
			return nAI;
		}
		return -1;
	}
public:
	GAIInfo() {

		this->m_cntWalkCount.setWaitFrameNum( DEFAULT_WALK_COUNT );
	}
	void reset() {
		this->m_Neutral.reset();
		this->m_cntWalkCount.reset();
		this->clearNextAIPatterns();
	}

};
