#include "GAchievement.h"
#include "GStaticData.h"

#include "GEnum.h"
#include <hpllib/general/HPLString.h>

GAchievement::GAchievement( int nType ) : HPLShootingObject( nType ) {

	this->setObjectType( ObjectType::EFFECT );

	HPLSprite* lpSprite = new HPLSprite();
	HPLSequencePair* lpSeqPair = getStaticData()->getSprite( SpriteType::ACHIEVEMENT)->getPair( nType )->clone();
	lpSprite->setSequence( nType, lpSeqPair );
	this->setSprite( lpSprite ) ;
	HPLImageInformation* lpInfo = lpSeqPair->left->getImageInformation(0);

	// g摜
	HPLSequence* lpFrameSeq;
	const int FRAME_W = lpFrameSeq->getImageInformation( 0 )->srcRect.getWidth();
	const int FRAME_H = lpFrameSeq->getImageInformation( 0 )->srcRect.getHeight();
	// size
	this->setSize( FRAME_W, FRAME_H);
	// hit rect
	this->setHitRect( 0,0,FRAME_W, FRAME_H );

	// 肠鎞
	// = speed * 
	const int DEFAULT_LIFT_UP = ACHIEVEMENT_LIFT_UP_SPEED * FRAME_H;
	this->m_cntLiftUp.setWaitFrameNum( DEFAULT_LIFT_UP );

	//! 肠ԂŎ~܂鎞
	const int DEFAULT_STAY = 75;
	this->m_cntStay.setWaitFrameNum( DEFAULT_STAY );
}
void GAchievement::draw() {
	HPLScroller* lpScroller = getStaticData()->m_ScrollManager.getScroller(0);
	const float ZOOM_RATE = 1;
	HPLVector vScreenCenter = lpScroller->getScreenPointFromVirtual( this->getCenter() );
	vScreenCenter.multiple( (float)ZOOM_RATE );
	float fRotateDegree = 0;
	int nAlpha = 255;
	int nBlendMode = DX_BLENDMODE_NOBLEND;
	if( this->getSprite() != NULL ) {
		HPLSequence* lpSeq = this->getSequence();
		// draw frame
		{
			HPLSequence* lpFrameSeq ;
		}

		//////////////////////////////////////////////////////////// {
		// draw object
		HPLVector vDelta( -80, 0 );
		getStaticData()->m_Basic.m_Graphics.draw(
			(int)( vScreenCenter.getX() + vDelta.getX() ),
			(int)( vScreenCenter.getY() + vDelta.getY()),
			lpSeq, this->getFaceDirection(),
			fRotateDegree, ZOOM_RATE, nAlpha, nBlendMode );
		if( ! getStaticData()->m_Game.isTheWorld() ) {
			if( lpSeq->step().isFinishAnimation ) {
				lpSeq->resetCounter();
			}
		}
	}
}
