#include "GCursor.h"
#include "GStaticData.h"

#include <hpllib/general/HPLString.h>
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/system/HPLFile.h>
#include <hpllib/general/HPLString.h>

using namespace std;

static const char TRUE_LABEL[] = "TRUE";
static const char FALSE_LABEL[] = "FALSE";
bool GCursorSetting::loadSettings( const char* lpszFilePath, GCursorSetting arySettings[] ) {
	vector<string> vecLines;
	try {
		vecLines = HPLFile::loadStringFromFile( lpszFilePath, true );
	} catch( ... ) {
		return false;
	}

	const int MAX_LINES = vecLines.size();
	for( int i = 0; i < MAX_LINES; i ++ ) {
		vector<string> vecItems = HPLString::split( vecLines[i], ",");
		if( vecItems.size() < GCursorSettingType::MAX_NUM ) {
#ifdef _DEBUG
			HPLError::assertIt( false, "");
#else
			continue;
#endif
		}
		int nType = atoi( vecItems[GCursorSettingType::TYPE].c_str());
		arySettings[ nType].m_nCursorType = nType;
		for( int j = 0; j < vecItems.size() && j < GCursorSettingType::MAX_NUM; j ++ ) {
			string str = HPLString::trim( vecItems[j] );
			switch( j ) {
			case GCursorSettingType::NAME:
				arySettings[ nType].m_strName = str;
				break;
			case GCursorSettingType::DELTA_X:
				arySettings[nType].m_vPointerDelta.setX( atof( str.c_str()));
				break;
			case GCursorSettingType::DELTA_Y:
				arySettings[nType].m_vPointerDelta.setY( atof( str.c_str()));
				break;
			case GCursorSettingType::HAS_READY:
				if( HPLString::equals( str, TRUE_LABEL ) ) {
					arySettings[nType].m_bIsHasReady = true;
				} else if( HPLString::equals( str, FALSE_LABEL ) ) {
					arySettings[nType].m_bIsHasReady = false;
				} else {
#ifdef _DEBUG
					HPLError::assertIt( false, "");
#endif
				}
				break;
			}
		}
	}
	return true;
}

GCursor::GCursor(): DXPlayer( 0, KeyMap::MAX_KEY) {
	// object type
	this->setObjectType(ObjectType::PLAYER);
	// set hp
	this->setHPMax(100 + 30);
	this->setHP(this->getHPMax());
	this->setObjectAttribute( ObjectAttribute::GRAVITY, true );
	this->setSize(32,32);
	this->setHitRect(0,0,32,32);
	this->getTrigger()->setTrigger( TriggerType::ON_THE_GROUND, false );
	// hit to block
	this->setObjectAttribute( ObjectAttribute::HIT_TO_BLOCK, true );

	this->setObjectAttribute( ObjectAttribute::HIT_TO_ENEMY, true );
	// G
	this->invCounter = new HPLCounter( static_cast<int>( 100 ) );

//	this->m_nLine = 0;

	this->m_nItemType = -1;
	this->m_nMouseInput = 0;
	this->m_nPrevMouseInput = 0;

	GCursorSetting::loadSettings( "data\\image\\Player\\CursorSetting.txt",
		this->m_aryCursorSettings );

	this->m_NameSet.load( "data\\image\\Player\\ToolName.txt" );
}

void GCursor::setup() {
	// set sprite
	this->setSprite( getStaticData()->getSprite(
		SpriteType::CURSOR )->clone() );
}


void GCursor::draw(){
	// area
	HPLRect rArea = this->getArea();
	// screen left top
	HPLVector vScreenCenter = this->getMousePosFloat();
	// setting
	GCursorSetting* lpSetting = this->getSetting( this->getType());
	// ƃYĕ\
	HPLVector vAdd = lpSetting->m_vPointerDelta;
	vAdd.multiple( -1 );
	vAdd.add( 16,16);




//	vScreenLeftTop.multiple( fZoomRate );
	// screen center
//	HPLVector vScreenCenter = lpScroller->getScreenPointFromVirtual( this->getCenter() );
	int nSeqID = this->getSequenceID();
	HPLSequence* lpSeq = this->getSprite()->getSequence( nSeqID, FaceDirection::LEFT );//this->getSequence();
	float fRotateDegree = 0;
	int nAlpha = 255;

	int nFaceDirection = FaceDirection::LEFT;
	////////////////////////////////////////////////////////////////// {̕`
	// draw
	getStaticData()->m_Basic.m_Graphics.draw(
		vScreenCenter.getX() + vAdd.getX(),
		vScreenCenter.getY() + vAdd.getY(), lpSeq, nFaceDirection,
		0, 1, nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA: DX_BLENDMODE_NOBLEND );

	// extra
	switch( this->getType()) {
	case CursorType::CLOTH_T:
	case CursorType::CLOTH_U:
		{
			int nClothSeqID = Sequence::Cursor::CLOTH_T;
			if( CursorType::CLOTH_U == this->getType()) {
				nClothSeqID = Sequence::Cursor::CLOTH_U;
			}
			// EɑΏۂ\
			HPLVector vClothAdd( 32,32);
			getStaticData()->m_Basic.m_Graphics.draw(
				vScreenCenter.getX() + vClothAdd.getX(),
				vScreenCenter.getY() + vClothAdd.getY(), 
				this->getSprite()->getSequence( nClothSeqID, FaceDirection::LEFT ), nFaceDirection,
				0, 1, nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA: DX_BLENDMODE_NOBLEND );
		}
		break;
	case CursorType::GIVE:
		if( this->m_GrabInfo.getObjectType() == ObjectType::ITEM ) {
			// item \

			getStaticData()->m_Basic.m_Graphics.draw(
				vScreenCenter.getX(),
				vScreenCenter.getY(),
				getStaticData()->getSequence( SpriteType::ITEMS, this->m_GrabInfo.getType() ),
				FaceDirection::LEFT, 0, 1 );
		}
		break;
	}
	// Target\
	getStaticData()->m_Basic.m_Graphics.draw(
		vScreenCenter.getX(),
		vScreenCenter.getY(),
		this->getSprite()->getSequence( Sequence::Cursor::TARGET, FaceDirection::LEFT ), nFaceDirection,
		0, 1, nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA: DX_BLENDMODE_NOBLEND );

	if( ! getStaticData()->m_Game.isTheWorld()) {
		lpSeq->step();
	}
}

int GCursor::rollBackState(bool bIsCancelAttack){
	this->changeState( StateType::STAND );
	return 0;
}

void GCursor::changeState(int st){

	int nCurrentState = this->getState()->getState();
	if( nCurrentState != st ) {
		// reset current seq counter
		this->getSequence()->resetCounter();
		// qbg󋵂Zbg
//		this->setHitAttack( false );

	}
	this->setState( st );
}

HPLSequence* GCursor::getSequence(){
	return this->getSprite()->getSequence( this->getSequenceID(), FaceDirection::LEFT);
}

int GCursor::getSequenceIDByType( int nType, int nState ) {
	int nSeqID = Sequence::Cursor::PICK_READY;
	switch( nType) {
	case CursorType::PICK:
		nSeqID = Sequence::Cursor::PICK_READY;
		break;
	case CursorType::GRAB:
		nSeqID = Sequence::Cursor::GRAB_READY;
		break;
	case CursorType::BEAT:
		nSeqID = Sequence::Cursor::BEAT_BIG_READY;//BEAT_READY;
		break;
	case CursorType::GIVE:
		return Sequence::Cursor::GIVE;
	case CursorType::PETTING:
		nSeqID = Sequence::Cursor::PETTING_READY;
		break;
	case CursorType::MIND_CONTROLLER:
		nSeqID = Sequence::Cursor::MIND_CONTROLLER_READY;
		break;
	case CursorType::FLAME_THROWER:
		return Sequence::Cursor::FLAME_THROWER;
	case CursorType::KNIFE:
		nSeqID = Sequence::Cursor::KNIFE_READY;
		break;
	case CursorType::NUKOSU:
		nSeqID = Sequence::Cursor::NUKOSU_READY;
		break;
	case CursorType::CLOTH_T:
	case CursorType::CLOTH_U:
		nSeqID = Sequence::Cursor::CLOTH_READY;
		break;
	case CursorType::PEN:
		return Sequence::Cursor::PEN;
	case CursorType::CHISEL:
		return Sequence::Cursor::CHISEL;
	case CursorType::ROTER:
		nSeqID = Sequence::Cursor::ROTER_READY;
		break;
	case CursorType::FOOT:
		nSeqID = Sequence::Cursor::FOOT_READY;
		break;
	case CursorType::ROPE:
		return Sequence::Cursor::ROPE;
	case CursorType::LEG_BAR:
		return Sequence::Cursor::LEG_BAR;
	case CursorType::SHOT:
		nSeqID = Sequence::Cursor::SHOT_READY;
		break;
	case CursorType::EYE_BAND:
		return Sequence::Cursor::EYE_BAND;
	default:
#ifdef _DEBUG
		ASSERT_IT_TYPE( nType, "TYPE");
#endif
		;
	}
	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();
	GCursorSetting* lpSetting = lpCursor->getSetting( nType);
	if( lpSetting->m_bIsHasReady ) {
		switch( nState ) {
		case StateType::ATTACK:
			nSeqID ++;
			break;
		}
	}
	return nSeqID;
}

int GCursor::getSequenceID() {
	int nSeqID = Sequence::Cursor::PICK_READY;

	int st = this->getState()->getState();

	nSeqID = GCursor::getSequenceIDByType( this->getType(), st );
	return nSeqID;
}
