#pragma once

#include <DXPlayer.h>
#include "GEnum.h"
#include <hpllib/math/HPLVectorInt.h>

#include <hpllib/object/HPL3DInfo.h>
#include <vector>
#include <hpllib/math/HPLMath.h>

#include "GNameSet.h"

using namespace std;

namespace Sequence {
	/** READYSTANDAsATTACK*ŕ\B
	  */
	namespace Cursor {
		enum Cursor {
			// 000
			PICK_READY,	// 
			PICK,
			GRAB_READY,
			GRAB,
			BEAT_READY,	// @
			// 005
			BEAT,
			GIVE,	//! d
			PETTING_READY,
			PETTING,
			MIND_CONTROLLER_READY,
			MIND_CONTROLLER,
			FLAME_THROWER,
			BEAT_BIG_READY,
			BEAT_BIG,
			CLOTH_READY,
			CLOTH,
			CLOTH_T,
			CLOTH_U,
			DISABLE,
			NUKOSU_READY,
			NUKOSU,
			
			KNIFE_READY,
			KNIFE,
			TARGET,
			PEN,
			CHISEL,
			ROTER_READY,
			ROTER,
			FOOT_READY,
			FOOT,
			ROPE,
			OK,
			NG,
			LEG_BAR,
			SHOT_READY,
			SHOT,
			EYE_BAND,

		};
	}

}
namespace CursorType {
	enum CursorType {
		// 000
		PICK,
		GRAB,
		BEAT,
		GIVE,
		PETTING,
		// 005
		MIND_CONTROLLER,
		FLAME_THROWER,
		CLOTH_T,
		CLOTH_U,
		NUKOSU,
		// 010
		KNIFE,
		PEN,
		CHISEL,
		ROTER,
		FOOT,
		// 015
		ROPE,
		LEG_BAR,
		SHOT,
		EYE_BAND,
//		DRILL,	// h
		
		MAX_NUM
	};
}


/** łIuWFNg
  */
class GGrabInfo {
public:
private:
	bool m_bIsEnable;
	int m_nObjectType;
	int m_nType;
	long m_lID;
public:
	int getObjectType() { return this->m_nObjectType;	}
	int getType() { return this->m_nType;	}
	long getID() { return this->m_lID;	}
	bool isEnable() { return this->m_bIsEnable;	}
	void setup( int nObjectType, int nType, long lID ) {
		this->m_nObjectType = nObjectType;
		this->m_nType = nType;
		this->m_lID = lID;
		this->m_bIsEnable = true;
	}
	void disable() {
		this->m_bIsEnable = false;
	}
public:
	GGrabInfo() {
		this->m_nObjectType = -1;
		this->m_nType = -1;
		this->m_lID = -1;
		this->m_bIsEnable = false;
	}
	~GGrabInfo() {}
};

namespace GCursorSettingType {
	enum GCursorSettingType {
		NAME,
		TYPE,
		DELTA_X,
		DELTA_Y,
		HAS_READY,
		MAX_NUM
	};
}

// J[\ݒ
class GCursorSetting {
public:
	string m_strName;
	int m_nCursorType;
	//! Ready/AttackԂǂ
	bool m_bIsHasReady;
	//! MousePosƂȂ鑊ΈʒuW
	HPLVector m_vPointerDelta;
public:
	GCursorSetting() {
		this->m_nCursorType = -1;
		this->m_bIsHasReady = false;
		this->m_vPointerDelta.set(0,0);
	}
	~GCursorSetting(){}

	static bool loadSettings( const char* lpszFilePath, GCursorSetting arySettings[] );
};

/** }EX̃IVbpiVoNX
  * ǂ͊OɔfāÃNXł͂Ȃ悤ɂ
  * Ăstep,disable
  */
class GPressing {
private:
	//! ςȂԂɓH
	bool m_bIsPressing;
	//! ŏɉςȂJEgɓ܂ł̎ԃJE^
	HPLCounter m_cntUntilStart;
	//! ςȂŗLɂȂԊu
	HPLCounter m_cntInterval;
public:
	bool isPressing() { return this->m_bIsPressing;	}
	void start() {
		this->m_bIsPressing = true;
		this->m_cntUntilStart.reset();
		this->m_cntInterval.end();
	}
	/** @retval	true	L
	  */
	bool step() {
		if( ! this->m_bIsPressing ) {
			return false;
		}
		if( this->m_cntUntilStart.step().isFinishAnimation ) {
			if( this->m_cntInterval.step().isFinishAnimation) {
				this->m_cntInterval.reset();

				// L
				return true;
			}
		}
		return false;
	}
	void disable( ) {
		this->m_bIsPressing = false;
	}
public:
	GPressing(){
		this->m_bIsPressing = false;
		const int DEFAULT_UNTIL_START = 20;
		this->m_cntUntilStart.setWaitFrameNum( DEFAULT_UNTIL_START );
		const int DEFAULT_INTERVAL = 3;
		this->m_cntInterval.setWaitFrameNum( DEFAULT_INTERVAL );
	}
	~GPressing(){}
};

/** J[\
  */
class GCursor : public DXPlayer {
public:
	// 3D info
//	HPL3DInfo m_3DInfo;	// XYŒׂ̂ŕsv
	//! łIuWFNg
	GGrabInfo m_GrabInfo;

	GNameSet m_NameSet;
	//! pressing
	GPressing m_Pressing;
private:
	//! dŗ^ACe
	int m_nItemType;
	//! }EXW(int)
	HPLVectorInt m_vMousePos;

	// 1FO
	HPLVectorInt m_vPrevMousePos;

	//! MOUSE_INPUT_LEFTƂ
	//! MOUSE_INPUT_4Ƃ̘a
	int m_nMouseInput;
	//! OF̏
	int m_nPrevMouseInput;

	//! settings
	GCursorSetting m_aryCursorSettings[ CursorType::MAX_NUM];

public: // Getter, Setter
	GCursorSetting* getSetting( int nType ) {
		if( nType < 0 || nType >= CursorType::MAX_NUM ) {
#ifdef _DEBUG
			ASSERT_IT_INDEX( nType, 0, CursorType::MAX_NUM );
#else
			return NULL;
#endif
		}
		return &this->m_aryCursorSettings[ nType];
	}

	bool isMouseButtonPressed( int nBit ) {
		return ( this->m_nMouseInput & nBit ) != 0;
	}
	bool isMouseButtonPressedNow( int nBit ) {
		return ( ( this->m_nMouseInput & nBit ) != 0 &&
			( this->m_nPrevMouseInput & nBit ) == 0 );
	}
	bool isMouseButtonReleaseNow( int nBit ) {
		return (( this->m_nMouseInput & nBit ) == 0 &&
			( this->m_nPrevMouseInput & nBit ) != 0 );
	}
	void setMouseInput( int nInput ) {
		this->m_nPrevMouseInput = this->m_nMouseInput;
		this->m_nMouseInput = nInput;
	}
	int getItemType() {
		return this->m_nItemType;
	}
	HPLVectorInt getMousePos() {
		return this->m_vMousePos;
	}
	HPLVector getMousePosFloat() {
		HPLVector vPos( this->m_vMousePos.x, 
			this->m_vMousePos.y );
		return vPos;
	}
	void updateMousePos( int nX, int nY ) {
		this->m_vPrevMousePos = this->m_vMousePos;
		this->m_vMousePos.set( nX, nY );
		this->m_vCenter.set(nX,nY );
	}
	HPLVector getMouseMoveDelta() {
		HPLVector vPosFloat = this->getMousePosFloat();
		HPLVector vPrevPosFloat( this->m_vPrevMousePos.x,
			this->m_vPrevMousePos.y );
		HPLVector vDelta = HPLVector::subtract( vPosFloat, vPrevPosFloat );
		return vDelta;
	}
public:
	GCursor();
	virtual ~GCursor() {
	}
public:	// override

	// s
	void die(HPLShootingObject* damageSource){
#ifdef _DEBUG
		HPLError::msg( "message", MB_OK, "No use");
#endif
	}

	void damage(float dmg, HPLShootingObject* damageSource,
		bool isInv, int damageState)
	{
#ifdef _DEBUG
		HPLError::msg( "message", MB_OK, "No use");
#endif
	}

	void draw();

	HPLSequence* getSequence();

	static int getSequenceIDByType( int nType, int nState );
	int getSequenceID();

	void changeState(int st);

	int rollBackState(bool bIsCancelAttack);

	void setup();

	bool isHeld(){
#ifdef _DEBUG
		HPLError::msg( "message", MB_OK, "No use");
#endif
		return false;
	}
private:
	void resetCommon();

public:
	/** ړ
	  */
	void resetChangeRoom();
	void resetStartGame();
	void getItem( int nItemType );
	/** wӏNbNB
	  * @param[in]	nX	ۂ̐΍W
	  */
	int click( int nScrX, int nY);

	/** 
	  */
	void grab( int nObjectType, int nType );

	/** 
	  */
	void release();
};
