#include "GDecal.h"
#include "GStaticData.h"

#include "GEnum.h"
#include <hpllib/general/HPLString.h>

GDecal::GDecal( int nType ) : HPLShootingObject( nType ) {

	this->setObjectType( ObjectType::EFFECT );

	HPLSprite* lpSprite = new HPLSprite();
	HPLSequencePair* lpSeqPair = getStaticData()->getSprite( SpriteType::DECAL)->getPair( nType )->clone();
	lpSprite->setSequence( nType, lpSeqPair );
	this->setSprite( lpSprite ) ;
	HPLImageInformation* lpInfo = lpSeqPair->left->getImageInformation(0);
	// size
	this->setSize( lpInfo->srcRect.getWidth(), lpInfo->srcRect.getHeight());
	// hit rect
	this->setHitRect( 0,0,lpInfo->srcRect.getWidth(), lpInfo->srcRect.getHeight() );

	const int DEFAULT_ALIVE = 20;
	this->m_cntAlive.setWaitFrameNum( DEFAULT_ALIVE );
}
void GDecal::draw( HPLVector vParentScreenCenter) {
//	HPLScroller* lpScroller = getStaticData()->m_ScrollManager.getScroller(0);
	const float ZOOM_RATE = 1;
	HPLVector vScreenCenter = this->m_vCenter;//lpScroller->getScreenPointFromVirtual( this->getCenter() );
	vScreenCenter.add( vParentScreenCenter );

	vScreenCenter.multiple( (float)ZOOM_RATE );

	float fRotateDegree = 0;
	int nAlpha = 200;
	int nBlendMode = DX_BLENDMODE_ALPHA;
	if( this->getSprite() != NULL ) {
		HPLSequence* lpSeq = this->getSequence();

		//////////////////////////////////////////////////////////// {
		// draw object
		getStaticData()->m_Basic.m_Graphics.draw(
			(int)( vScreenCenter.getX() ), (int)( vScreenCenter.getY()), lpSeq, this->getFaceDirection(),
			fRotateDegree, ZOOM_RATE, nAlpha, nBlendMode );
		if( ! getStaticData()->m_Game.isTheWorld() ) {
			if(lpSeq->step().isFinishAnimation ) {
				lpSeq->resetCounter();//&&  lpSeq->getLoopNumMax() >= 0 ) {
			}
			if( this->m_cntAlive.step().isFinishAnimation ) {
				this->die(NULL);
			}
		}
	}
}
