#include "GDecalManager.h"

#include "GStaticData.h"
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPLShootingMove.h>
#include <hpllib/game/HPLChaseInfo.h>

void GDecalManager::process(bool bIsMove, bool bIsAI) {
	HPLRect rGameRange = getStaticData()->getGameRange();
	for( list<GDecal*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		)
	{
		GDecal* lpDecal = *it;

		if( lpDecal->isAlive() ) {
			// move
			if( bIsMove ) {
				if( bIsAI ) {
					this->algorithm( lpDecal );

//					this->checkHitToEnemy( lpDecal );
				}
			}

		}

		if( lpDecal->isAlive()) {
			it ++;
		} else {
			delete lpDecal;
			it = this->getList()->erase( it );
		}
	}

	// add reserved items
	for( list<GDecal*>::iterator it = this->getReserves()->begin();
		it != this->getReserves()->end(); it ++ )
	{
		GDecal* lpDecal = *it;
		this->add( lpDecal );
	}
	if( this->getReserves()->size() > 0 ) {
		this->clearReserves();
	}
}
void GDecalManager::draw( HPLVector vCenter) {
	for( list<GDecal*>::iterator it = this->getList()->begin();
		it != this->getList()->end(); it ++
		)
	{
		GDecal* lpDecal = *it;
		if( lpDecal->isAlive()) {
			lpDecal->draw(vCenter );
		}
	}
}

GDecal* GDecalManager::create(int t, HPLVector center, int nAddType){//, float fZ ) {
	GDecal* lpDecal = new GDecal( t );
	lpDecal->setCenter( center );
	switch( nAddType ) {
	case HPL::AddType::LIST:
		this->getList()->push_back( lpDecal );
		break;
	case HPL::AddType::RESERVE:
		this->addReserve( lpDecal );
		break;
	}
	return lpDecal;
}


void GDecalManager::algorithm( GDecal* lpDecal ) {
}

