#include "GEffect.h"
#include "GStaticData.h"

#include "GEnum.h"
#include <hpllib/general/HPLString.h>

GEffect::GEffect( int nType ) : HPLShootingObject( nType ) {

	this->setObjectType( ObjectType::EFFECT );

	HPLSprite* lpSprite = new HPLSprite();
	HPLSequencePair* lpSeqPair = getStaticData()->getSprite( SpriteType::EFFECT)->getPair( nType )->clone();
	lpSprite->setSequence( nType, lpSeqPair );
	this->setSprite( lpSprite ) ;
	HPLImageInformation* lpInfo = lpSeqPair->left->getImageInformation(0);
	// size
	this->setSize( lpInfo->srcRect.getWidth(), lpInfo->srcRect.getHeight());
	// hit rect
	this->setHitRect( 0,0,lpInfo->srcRect.getWidth(), lpInfo->srcRect.getHeight() );
}
void GEffect::draw() {
	HPLScroller* lpScroller = getStaticData()->m_ScrollManager.getScroller(0);
	const float ZOOM_RATE = 1;
	HPLVector vScreenCenter = lpScroller->getScreenPointFromVirtual( this->getCenter() );
	vScreenCenter.multiple( (float)ZOOM_RATE );
	float fRotateDegree = 0;
	int nAlpha = 200;
	int nBlendMode = DX_BLENDMODE_ALPHA;
	if( this->getSprite() != NULL ) {
		HPLSequence* lpSeq = this->getSequence();

		switch( this->getType()) {
		case Sequence::Effect::PARTICLE:
			{
				// 
				int nCol = this->getColor();
				if( nCol < 0 || nCol >= ColorType::MAX_NUM ) {
					nCol = 0;
#ifdef _DEBUG
					ASSERT_IT_INDEX( nCol, 0, ColorType::MAX_NUM );
#endif
					return;
				}
				// draw
				SetDrawBlendMode( DX_BLENDMODE_ALPHA, nAlpha );
				DrawBox( vScreenCenter.getX(), vScreenCenter.getY(),
					vScreenCenter.getX() + this->getWidth(), vScreenCenter.getY() + this->getHeight(),
					GetColor(COLORS[ nCol][0],COLORS[ nCol][1],COLORS[ nCol][2] ), TRUE );
				SetDrawBlendMode( DX_BLENDMODE_ALPHA, nAlpha );
				if( ! getStaticData()->m_Game.isTheWorld()) {
					if( this->m_cntAlive.step().isFinishAnimation ) {
						this->die(NULL );
					}
				}
			}
			break;
		default:
			//////////////////////////////////////////////////////////// {
			// draw object
			getStaticData()->m_Basic.m_Graphics.draw(
				(int)( vScreenCenter.getX() ), (int)( vScreenCenter.getY()), lpSeq, this->getFaceDirection(),
				fRotateDegree, ZOOM_RATE, nAlpha, nBlendMode );
			if( ! getStaticData()->m_Game.isTheWorld() ) {
				if(lpSeq->step().isFinishAnimation &&  lpSeq->getLoopNumMax() >= 0 ) {
					this->die(NULL);
				}
			}
		}
	}
}
