#pragma once

#include <hpllib/object/HPLShootingObject.h>
#include <hpllib/object/HPL3DInfo.h>
#include <hpllib/general/HPLColor.h>
#include <hpllib/general/HPLPointerTool.h>
#include <hpllib/general/HPLCounter.h>

#include <vector>
#include <string>
using namespace std;

namespace Sequence {
	namespace Effect {
		enum Effect {
			// 000
			HIT,
			BLOOD,
//			PARAMETER_CHANGE,	//! p[^ςƂm点
			EM_ANGRY,	//! {
			EM_ASE,//! i|A߈
			EM_CONFUSE,//! 
			// 005
			EM_HATENA,
			EM_HAZUKASHI,
			EM_HEART,//! FD
			EM_REBELLION,
			EM_SNAKE,
			// 010
			PARTICLE,
			ZZZ,
			MAX_NUM
		};
	}
}
/** GtFNg

*/
class GEffect : public HPLShootingObject {
public:
	// 3D info
	HPL3DInfo m_3DInfo;
private:
	//! V[PXɈˑȂ
	HPLCounter m_cntAlive;
	int m_nNum;
	// maxȏ̏ꍇAEnkoCounterType킷
	int m_nParameterType;
public:
	GEffect( int nType );
	virtual ~GEffect() {
	}
public:
	void die(HPLShootingObject* damageSource) {
		this->setAlive( false );
	}
	void draw();

	void changeState( int nState ) {
		this->setState( nState );
	}
	HPLSequence* getSequence() {
		HPLSprite* lpSprite = this->getSprite();
		ASSERT_IT_NULL( lpSprite );
		HPLSequence* lpSeq = this->getSprite()->getSequence( this->getSequenceID(),
			FaceDirection::LEFT );
		ASSERT_IT_NULL( lpSeq );
		return lpSeq;
	}
	int getSequenceID() {
		return this->getType();
	}
};
