#include "GEnemy.h"

#include "GStaticData.h"
#include <hpllib/general/HPLString.h>

#include <hpllib/action/HPL3DActionMoveTool.h>

int GEnemy::getHitArea3DType( int nType ) {
	switch( nType ) {
	case EnemyType::SLIME:
		return HitArea3DType::STAND;
	}
	return HitArea3DType::STAND;
}

void GEnemy::setup( int nType ) {
	this->setObjectType( ObjectType::ENEMY );

	this->setType( nType );

	// sprite
	this->setSprite( getStaticData()->getSprite( SpriteType::SLIME )->clone() );
	// set size
	HPLSequence* lpSeq = this->getSequence();
	this->setSize(
		lpSeq->getImageInformation()->srcRect.getWidth(),
		lpSeq->getImageInformation()->srcRect.getHeight());

	HPLEnemySetting* lpSetting = getStaticData()->m_ObjectManager.m_EnemyManager.getSetting(
		nType );
	// set hit rect
	this->setHitRect( lpSetting->m_HitRect);//4,16,56,32 );

	this->setColor(0);
}
HPLSequence* GEnemy::getSequence() {
	return this->getSprite()->getSequence( this->getSequenceID(), FaceDirection::LEFT );
}
int GEnemy::getSequenceID() {
	return 0;
}
/**
	ASY
*/
//	void algorithm();

void GEnemy::draw() {
	HPLScroller* lpScroller = getStaticData()->m_ScrollManager.getScroller(0);
	HPLVector vScreenCenter = lpScroller->getScreenPointFromVirtual( this->getCenter() );
	HPLSequence* lpSeq = this->getSequence();
	if( this->getSprite() != NULL ) {
		
		const int nAlpha = 255;
		const double dRotateDegree = 0;
		const float ZOOM_RATE = 1;
		// SEnko\
		if( this->isHolding()) {
			GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();
			HPLVector vCen = this->m_vCenter;
			HPLVector vAdd = getStaticData()->m_ObjectManager.m_EnemyManager.getHoldDeltaFromCenter( this );
			vCen.add( vAdd );
			lpEnko->m_vCenter = vCen;

			lpEnko->m_3DInfo.setZ( this->m_3DInfo.getZ()- 1);
			lpEnko->draw();
		}
		getStaticData()->m_Basic.m_Graphics.draw(
			(int)( vScreenCenter.getX() ), (int)( vScreenCenter.getY()), lpSeq, 
			FaceDirection::LEFT,
			dRotateDegree, ZOOM_RATE, nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA : DX_BLENDMODE_NOBLEND );
		if( ! getStaticData()->m_Game.isTheWorld() ) {
			lpSeq->step();
		}
	}
}

void GEnemy::die(HPLShootingObject* damageSource) {
	this->setAlive( false );
/*	GEffect* lpEffect = getStaticData()->m_ObjectManager.m_EffectManager.create(
		Sequence::Effect::EXP,
		this->m_vCenter, true );*
	lpEffect->m_nLine = this->m_nLine;
	lpEffect->setColor( this->getColor());
	getStaticData()->m_MixerManager.play( SE::ENEMY_DEAD, false );*/
		
}

void GEnemy::damage(float dmg, HPLShootingObject* damageSource) {
	this->die( damageSource );
}

// override
void GEnemy::changeState( int nState ) {
	if( this->getState()->getState() != nState ) {
		this->getSequence()->resetCounter();
	}
	this->setState( nState );
}
