#pragma once

#include <hpllib/object/HPLShootingobject.h>
#include <hpllib/object/HPL3DInfo.h>
#include <hpllib/general/HPLPointerTool.h>
#include "GEnum.h"
#include <hpllib/game/HPLAttackInformation.h>
//#include "GArmManager.h"

//#include "GSlotManager.h"
//#include "GEnemyConst.h"
#include "GEffect.h"

#include <vector>
#include <hpllib/game/slg/HPLAIInfo.h>
#include <hpllib/object/HPLEmotionIcon.h>

using namespace std;


namespace EnemyType {
	enum EnemyType {
		SLIME,
	};
}
/** GNX
  * NeutralłǂAesɍ킹Aj[Vv̂EnemyƂ
  */
class GEnemy: public HPLShootingObject{
public:
	// 3D info
	HPL3DInfo m_3DInfo;

	//! AI info
	HPLAIInfo m_AIInfo;

	//! ACR
	HPLEmotionIcon m_EmotionIcon;
private:
	//! 3D蔻
	int m_nHitArea3DType;
public:
	int getHitArea3DType() { return this->m_nHitArea3DType;	}
public:
	GEnemy():HPLShootingObject(0){}
	GEnemy( int nType ) : HPLShootingObject( nType ) {
		this->setup( nType );
	}
	virtual ~GEnemy() {
	}
	void setup( int nType );

public:	// override
	HPLSequence* getSequence();
	int getSequenceID();
	/**
		ASY
	*/
//	void algorithm();

	void draw();

	void die(HPLShootingObject* damageSource);

	void damage(float dmg, HPLShootingObject* damageSource);

	// override
	void changeState( int nState );

	static int getHitArea3DType( int nType );
};
