#include "GEnkoManager.h"

#include "GStaticData.h"

void GEnkoManager::startWalk( GEnko* lpEnko, HPLVector vGoalXZ, float fSpeed ) {
	const float RESIST = getStaticData()->m_Setting.resist;

	// Xs[h
	const float SPD = fSpeed + RESIST;
	HPLVector vCenXZ = HPL3DInfo::getCenterXZ( lpEnko, &lpEnko->m_3DInfo );

	HPLVector vVelXZ = HPLVector::subtract( vGoalXZ, vCenXZ );
	HPLVector vLen = vVelXZ;

	vVelXZ.setLength( SPD );

	HPL3DInfo::setVelocityAngleXZ( 
		lpEnko, &lpEnko->m_3DInfo, vVelXZ );
	const int FRAME_COUNT = (int)( vLen.getLength() / SPD );

	lpEnko->m_AIInfo.m_cntWalkCount.setWaitFrameNum( FRAME_COUNT );
	lpEnko->m_AIInfo.m_cntWalkCount.reset();

	lpEnko->m_AIInfo.setAIPattern( HPL::AIPattern::N_WALK );
	lpEnko->changeState( StateType::WALK );
	lpEnko->setVelocity( SPD );
	// 
	lpEnko->setFaceDirection(
		vVelXZ.getX() > 0 ? FaceDirection::RIGHT : FaceDirection::LEFT );
}

void GEnkoManager::doAI( GEnko* lpEnko ) {

	// AIŝ́ALԂƂ
	// -STAND/WALKȂǁAʏ퓮
	// -AttackState
	// L͏
	// -Dead/Damage
	// -Hold

	if( lpEnko->getState()->isHeldState() ||
		lpEnko->getState()->isDeadState() ||
		lpEnko->getState()->isDamageState() )
	{
		return ;
	}
/*	switch( lpEnko->getState()->getState() ) {
	case StateType::CROUCH:
		return;
	}*/

	// ɂĂ͍słȂ
	if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::EYE_BAND ) > 0 ||
		getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::ROPE ) > 0 ||
		getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::ROTER ) > 0 ||
		getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::LEG_BAR ) > 0 )
	{
		return;
	}

	const float RESIST = getStaticData()->m_Setting.resist;

	int st = lpEnko->getState()->getState();

	// ݂̏Ԃ̔h
	switch( lpEnko->m_AIInfo.getAIPattern()) {
	case HPL::AIPattern::NEUTRAL:
		// 
		if( lpEnko->m_AIInfo.m_Neutral.m_cntWaitForNextMove.step().isFinishAnimation ) {
			lpEnko->m_AIInfo.m_Neutral.m_cntWaitForNextMove.reset();
			if( HPLMath::nextInt(0,100 ) < lpEnko->m_AIInfo.m_Neutral.m_nMovePercentage ) {
				// m𖞂
				// S[
				HPLVector vGoalXZ;
				vGoalXZ.setByDegree( HPLMath::nextFloat(0,360));
				const float R_MIN = 80;
				const float R_MAX = 150;
				vGoalXZ.setLength( HPLMath::nextFloat( R_MIN, R_MAX ) );

				HPLVector vCenterXZ = HPL3DInfo::getCenterXZ( lpEnko, &lpEnko->m_3DInfo );

				vGoalXZ.add( vCenterXZ );
				const float SPD = 0.5f;
				this->startWalk( lpEnko, vGoalXZ, SPD );

				
			}
		}
		if( lpEnko->m_AIInfo.m_Neutral.m_cntBored.step().isFinishAnimation ) {
			lpEnko->m_AIInfo.m_Neutral.m_cntBored.reset();
			if( HPLMath::nextInt( 0, 100) < lpEnko->m_AIInfo.m_Neutral.m_nBoredPercentage ) {
				// BoredɂȂ

				int nNextState = StateType::BORING_2;
				if( HPLMath::nextInt( 0, 100 ) < getStaticData()->m_Save.m_EnkoParameters.m_Parameters.get( ParameterType::FATIGUE ) ) {
					nNextState = StateType::BORING;
				}
				lpEnko->changeState( nNextState );
			}
		}


		if( getStaticData()->m_Save.m_EnkoParameters.m_Parameters.get( ParameterType::FATIGUE ) >= FATIGUE_SLEEP_THRESHOLD ||
			getStaticData()->m_Game.getHour() >= NIGHT_HOUR ||
			getStaticData()->m_Game.getHour() <= 4)
		{
			// J܂ɂȂQ
			lpEnko->m_AIInfo.setAIPattern( HPL::AIPattern::SLEEP );
			lpEnko->changeState( StateType::WALK );
		}
		break;
	case HPL::AIPattern::N_WALK:
		{
			bool bIsStop = false;

			if( lpEnko->m_AIInfo.m_cntWalkCount.step().isFinishAnimation ) {


				// ~܂
				bIsStop = true;
			} else {
				HPLVector vVelXZ = HPL3DInfo::getVelocityAngleXZ( lpEnko, &lpEnko->m_3DInfo );
				if(
					vVelXZ.getX() >= 0 && lpEnko->getTrigger()->getTrigger( TriggerType::HIT_TO_THE_RIGHT ) ||
					vVelXZ.getX() <= 0 && lpEnko->getTrigger()->getTrigger( TriggerType::HIT_TO_THE_LEFT ) ||
					vVelXZ.getY() >= 0 && lpEnko->getTrigger()->getTrigger( TriggerType::HIT_TO_THE_BOTTOM ) ||
					vVelXZ.getY() <= 0 && lpEnko->getTrigger()->getTrigger( TriggerType::HIT_TO_THE_TOP ) )
				{
					// ǂɓ
					// ~܂
					bIsStop = true;
				} else  {

					// 葬x
					HPLVector vVelXZ = HPL3DInfo::getVelocityAngleXZ(
						lpEnko, &lpEnko->m_3DInfo );
					vVelXZ.setLength( lpEnko->getVelocity() );
					
					HPL3DInfo::setVelocityAngleXZ( 
						lpEnko, &lpEnko->m_3DInfo, vVelXZ );
				}
			}

			if( bIsStop ) {
				lpEnko->m_AIInfo.m_cntWalkCount.reset();
				lpEnko->changeState( StateType::STAND );
				HPL3DInfo::setVelocityAngleXZ( 
					lpEnko, &lpEnko->m_3DInfo, HPLVector(0,0) );

				int nNextAI = lpEnko->m_AIInfo.getNextAIPattern();
				switch( nNextAI ) {
				case HPL::AIPattern::EAT:
				case HPL::AIPattern::SLEEP:
				case HPL::AIPattern::PLAY:
					lpEnko->m_AIInfo.setAIPattern(
						nNextAI );
					break;
				default:
					lpEnko->m_AIInfo.setAIPattern( HPL::AIPattern::NEUTRAL );
				}
			}
		}
		break;
	case HPL::AIPattern::EAT:
	case HPL::AIPattern::PLAY:
		break;
	case HPL::AIPattern::SLEEP:
		{
			// 
			// bedT
			GNeutral* lpNeutral = getStaticData()->m_ObjectManager.m_NeutralManager.getByType(
				Sequence::Neutral::BED );

			switch( st ) {
			case StateType::WALK:
				if( lpNeutral ) {
					// 
					// ߂Â
					HPLChaseInfo chase;
					const float ACCEL = 0.5f + RESIST;
					const float MAX_SPEED = 0.5f + RESIST;
					chase.setup( ChaseType::ADD_ACCEL_VECTOR, ACCEL, MAX_SPEED, 0 );

					HPLVector vCenXZ = HPL3DInfo::getCenterXZ( lpEnko, &lpEnko->m_3DInfo );
					// xbhXYSS[&p
					HPLVector vBedCenXY = lpNeutral->m_vCenter;
					HPLVector vSubXZ = HPLVector::subtract( vBedCenXY, vCenXZ );
					HPLVector vVelXZ = HPL3DInfo::getVelocityAngleXZ( lpEnko, &lpEnko->m_3DInfo );

					vVelXZ = chase.chase( vCenXZ, vBedCenXY, vVelXZ );
					HPL3DInfo::setVelocityAngleXZ( lpEnko, &lpEnko->m_3DInfo, vVelXZ );

					const float LEN_THRESHOLD = 150;
					if( vSubXZ.getLength() < LEN_THRESHOLD ) {
						// ǂ蒅
						// ߂܂
						getStaticData()->m_ObjectManager.m_NeutralManager.grab(
							lpNeutral, lpEnko );
						// Q
						lpEnko->changeState( StateType::SLEEPING );
					}
				} else {
					// bed
					// [Ȃ̂ł̏ŐQ
					lpEnko->changeState( StateType::SLEEPING );
				}
				break;
			case StateType::SLEEP:
			case StateType::SLEEPING:
				if( getStaticData()->m_Game.getHour() >= MORNING_HOUR && 
					getStaticData()->m_Game.getHour() < NIGHT_HOUR)
				{
					// 
					getStaticData()->m_ObjectManager.m_NeutralManager.release(NULL, lpEnko );
					// N
					lpEnko->rollBackState( true );
				}
				break;
			}

		}
		break;
	case HPL::AIPattern::REST:
		break;
	case HPL::AIPattern::ESCAPE:
		break;
	default:
#ifdef _DEBUG
		ASSERT_IT_TYPE( lpEnko->m_AIInfo.getAIPattern(), "AI Pattern")
#endif
		;
	}

	// p[^`FbN


	// `FbN
}

