#include "GEnkoManager.h"

#include <hpllib/action/HPLActionMoveTool.h>
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPLPlayerMoveTool.h>

#include "GStaticData.h"

#include <hpllib/math/HPLMath.h>

using namespace std;

void GEnkoManager::move(GEnko* lpEnko) {
	// matrix
	HPLMatrix<int>* matrix = getStaticData()->getBlockManager()->getBlockMatrix();

	// tilesize
	const int TILE_SIZE = getStaticData()->m_Setting.tileSize;

	const int TOP_EDGE = 0;
	// Ë
	HPLRect limitArea(0,TOP_EDGE,
		(float)(matrix->getColumnSize() * TILE_SIZE),
		(float)(matrix->getRowSize() * TILE_SIZE) - TOP_EDGE);
	HPLRect rHitAreaXZ = HPL3DActionMoveTool::getStandHitAreaXZ( lpEnko, &lpEnko->m_3DInfo, Z_THRESHOLD );
	float fLeftOver = limitArea.getX() - rHitAreaXZ.getX();
	if( fLeftOver > 0 ) {
		lpEnko->m_vCenter.add( fLeftOver, 0 );
		lpEnko->m_vVelocityAngle.setX(0);
	} else {
		float fRightOver = rHitAreaXZ.getRight() - limitArea.getRight();
		if( fRightOver > 0 ) {
			lpEnko->m_vCenter.add( -fRightOver, 0 );
			lpEnko->m_vVelocityAngle.setX(0);
		}
	}
	float fTopOver = limitArea.getY() - rHitAreaXZ.getY();
	if( fTopOver > 0 ) {
		lpEnko->m_3DInfo.setZ( lpEnko->m_3DInfo.getZ() + fTopOver );
		lpEnko->m_3DInfo.setDZ(0);
	} else {
		float fBottomOver = rHitAreaXZ.getBottom() - limitArea.getBottom();
		if( fBottomOver > 0 ) {
			lpEnko->m_3DInfo.setZ( lpEnko->m_3DInfo.getZ() -fBottomOver );
			lpEnko->m_3DInfo.setDZ(0);
		}
	}

	bool bIsOnTheGround = lpEnko->getTrigger()->getTrigger( TriggerType::ON_THE_GROUND );

	HPLSequence* lpSeq = lpEnko->getSequence();

	//! ԑJ
	this->checkState( lpEnko );

	if( lpEnko->getState()->isDamageState()) {
		if( bIsOnTheGround ) {
			// nʂɕt
			if( ! lpEnko->isAlive() ||
				lpEnko->getHP() <= 0 )
			{
				// ł
				lpEnko->die( NULL );
			} else {

				if( lpSeq->getState().isFinishAnimation ) {
					lpEnko->rollBackState( true );
				}
			}
		} else {
		}
	}
}
void GEnkoManager::collisionCheck(GEnko* lpEnko) {
	CollisionState stResultX, stResultZ;
	//const float RESIST = getStaticData()->m_Setting.resist;
	const float BOUNCE_RATE_X = 1;
	const float BOUNCE_RATE_Z = 1;

	getStaticData()->m_CollisionCheckTool.commonCollisionObject3D(
		lpEnko, &lpEnko->m_3DInfo, Z_THRESHOLD,
		stResultX, stResultZ, BOUNCE_RATE_X, BOUNCE_RATE_Z,
		HitArea3DType::STAND);

}

/** ԑJڃ`FbN
  */
void GEnkoManager::checkState( GEnko* lpEnko ) {
	int st = lpEnko->getState()->getState();
	bool bIsOnTheGround = lpEnko->getTrigger()->getTrigger( 
		TriggerType::ON_THE_GROUND );
	HPLSequence* lpSeq = lpEnko->getSequence();

	switch( st ) {
	case StateType::STAND:
		{
			const int TARGETS[] = {
				GIntervalEffectType::ROTER,
				GIntervalEffectType::L_JUICE,
				GIntervalEffectType::PEE,
				GIntervalEffectType::CUM,
			};
			const int MAX_NUM = SIZEOF( TARGETS );
			for( int i = 0; i < MAX_NUM; i ++ ) {
				int nType = TARGETS[i];
				if( lpEnko->m_aryIntervalEffects[ nType ].isEnable()) {
					// enable
					if( lpEnko->m_aryIntervalEffects[ nType].m_cntInterval.step().isFinishAnimation ) {
						lpEnko->m_aryIntervalEffects[ nType].m_cntInterval.reset();

						bool bIsCreateParticle = false;
						int nR = 80;
						int nG = 100;
						int nB = 200;
						vector<pair<int, int> > vecParamDeltas;
						getStaticData()->m_Save.m_EnkoParameters.getIntervalEffectParamDeltas(
							i, vecParamDeltas );

						// p[^ω
						getStaticData()->m_Save.m_EnkoParameters.changeParams(
							vecParamDeltas, true );
						switch(i) {
						case GIntervalEffectType::ROTER:
							// damage
							lpEnko->changeState( StateType::DAMAGE_A_4 );
							break;
						case GIntervalEffectType::L_JUICE:
							bIsCreateParticle = true;
							break;
						case GIntervalEffectType::PEE:
							bIsCreateParticle = true;
							nR = 255; 
							nG = 200;
							nB = 50;
							break;
						case GIntervalEffectType::CUM:
							bIsCreateParticle = true;
							nR = 255;
							nG = 255;
							nB = 255;
							break;
						}
						if( bIsCreateParticle ) {
							lpEnko->changeState( StateType::DAMAGE_A_4 );
							const int PART_NUM = 3;
							for( int j = 0; j < PART_NUM; j ++ ) {
								HPLVector vCen = lpEnko->m_vCenter;
								vCen.add( 0, 10 );
								GEffect* lpEffect = getStaticData()->m_ObjectManager.m_EffectManager.create(
									Sequence::Effect::PARTICLE, vCen, HPL::AddType::LIST );
								lpEffect->m_3DInfo.setZ( lpEnko->m_3DInfo.getZ() + 0.1f );
							}
						}
					}
				}
			}
		}
		break;
	case StateType::DAMAGE_FLYDOWN:
	case StateType::FLYDOWN:
		if( bIsOnTheGround ) {
			// n
			if( ! lpEnko->m_bIsRebound ) {
				// 烊oEh
				lpEnko->m_bIsRebound = true;
				const float SPD = 5;
				getStaticData()->m_ObjectManager.jump(
					lpEnko, SPD );

				// ԕύX
				lpEnko->changeState( StateType::FLYUP );
			} else {
				// I
				lpEnko->m_bIsRebound = false;
				lpEnko->rollBackState(true);
			}
		}
		break;
	case StateType::EATING:
		if( lpSeq->getState().isFinishAnimation ) {
			lpEnko->changeState( StateType::STAND );

			// Ă郂mACełΗ
			switch( lpEnko->m_GrabObject.getObjectType()){
			case ObjectType::ITEM:
				lpEnko->m_GrabObject.clear();
				break;
			}
		}
		break;
	case StateType::BIND_DAMAGE:
		if( lpSeq->getState().isFinishAnimation ) {
			lpEnko->changeState( StateType::BIND_2 );
		}
		break;
	case StateType::BORING:
	case StateType::BORING_2:
		if( lpSeq->getState().isFinishAnimation ) {
			//lpEnko->changeState( StateType::STAND );
			lpEnko->rollBackState(true);
		}
		break;
	case StateType::BIND_BORED:
		if( lpSeq->getState().isFinishAnimation ) {
			lpEnko->changeState( StateType::BIND );
		}
		break;
	case StateType::BIND:
		switch( lpEnko->getSequenceID()) {
		case Sequence::Enko::HANGED_2:
			if( lpEnko->m_AIInfo.m_Neutral.m_cntBored.step().isFinishAnimation ) {
				lpEnko->m_AIInfo.m_Neutral.m_cntBored.reset();
				if( HPLMath::nextInt( 0, 100) < lpEnko->m_AIInfo.m_Neutral.m_nBoredPercentage ) {
					// g났
					lpEnko->changeState( StateType::BIND_BORED );
				}
			}
			break;
		}
		/*
		switch( lpEnko->getHoldEnemyType()) {
		case 
		}*/
		break;
	}
}
