#include "GGUI.h"

#include "GStaticData.h"
#include <hpllib/general/HPLString.h>
#include "GEnkoManager.h"

using namespace ScenarioItemConsts;


/** 
  * @param[in]	strLine	
  * @param[in]	nX,nWidth	͈̔͂Œ񂹂
  */
int GGUI::getCenterAlignLeft( int nStrLen, int nX, int nWidth ) {
	int nResult = nWidth / 2 - ( (float)nStrLen - 0.5f ) * FONT_W + nX;
	return nResult;
}

void GGUI::drawPalette() {
	const int TILE_SIZE = getStaticData()->m_Setting.tileSize;
	const int LEFT = 15 * TILE_SIZE;
	const int TOP = 0;

	const int WINDOW_WIDTH = getStaticData()->m_Setting.windowWidth;

	//! \
	//! \Ȃꍇ-1̂܂܂ɂ
	//! ȂA\͓Ɣ͕\Ȃ
	int nTextResource = -1;

	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();
	bool bIsLeftClick = lpCursor->isMouseButtonPressedNow( MOUSE_INPUT_LEFT );
	bool bIsLeft = lpCursor->isMouseButtonPressed( MOUSE_INPUT_LEFT );

	HPLVector vMousePos = lpCursor->getMousePosFloat();

	//! }EXɊm鉡iXe[^X
	const int STATUS_MOUSE_RANGE_WIDTH = 200;

	const int STATUS_INTERVAL_Y = FONT_H + 8;

	// Enko
	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();
	HPLRect rHitAreaXY = lpEnko->getHitArea();

	// dialog\Ă
	bool bIsDialogShow = this->m_nDialogType >= 0;

	// draw status
	{
		const int START_LEFT = LEFT + 5;
		const int START_TOP = TOP + 5;
		for( int i = 0; i < ParameterType::MAX_NUM; i ++ ) {
			int nX = START_LEFT;
			int nY = START_TOP + i * STATUS_INTERVAL_Y;

			// draw effect
			this->m_aryParameterEffects[i].drawAndStep(
				nX, nY );
			if( this->m_nPaletteType == PaletteType::NONE ) {
				// ͈
				HPLRect rRect( nX, nY, STATUS_MOUSE_RANGE_WIDTH, STATUS_INTERVAL_Y );
				if( rRect.isPointInRect( vMousePos )) {
					nTextResource = i;
				}
			}
		}

	}
	{
		// Researcher Data
		const int START_LEFT = LEFT + 5;
		const int START_TOP = TOP + 5 + STATUS_INTERVAL_Y * ParameterType::MAX_NUM + 5;
		vector<string> vecLines;
		vecLines.push_back( 
			HPLString::chrToStr( 
			"\t: %ld", getStaticData()->m_Save.m_ResearcherData.getMoney()) );
		vecLines.push_back( 
			HPLString::chrToStr( 
			"oߓ\t: %ld", getStaticData()->m_Save.m_ResearcherData.getElapseDays()) );
		vecLines.push_back( 
			HPLString::chrToStr( 
			"\t: %ld", getStaticData()->m_Save.m_ResearcherData.getRips()) );
		const int MAX_LINES = vecLines.size();
		for( int i = 0; i < MAX_LINES; i ++ ) {
			int nY = START_TOP + i * STATUS_INTERVAL_Y;
			int nR = 255;
			int nG = 255;
			int nB = 255;
			if( i == 0 ) {
				nB = 0;
			}
			// money
			DrawString( START_LEFT, nY,
				vecLines[i].c_str(), GetColor(255,255,0));

			if( this->m_nPaletteType == PaletteType::NONE ) {
				HPLRect rRect( START_LEFT, nY, STATUS_MOUSE_RANGE_WIDTH, STATUS_INTERVAL_Y );
				if( rRect.isPointInRect( vMousePos ) ) {
					nTextResource = TextResourceType::MONEY + i;
				}
			}
		}



	}


	const int CLOSE_TAB_LEFT = WINDOW_WIDTH - 32;
	
	const int OPEN_TAB_LEFT = LEFT;
	const int TOOL_TAB_TOP = 32;
	// Tool Palette
	switch( this->m_nPaletteType ) {
	case PaletteType::TOOL:
		{
			// ^u\
			getStaticData()->m_Basic.m_Graphics.draw(
				OPEN_TAB_LEFT, TOOL_TAB_TOP, getStaticData()->getSequence(
				SpriteType::COMMON, Sequence::Common::TOOL_TAB ) );
			// BASE
			getStaticData()->m_Basic.m_Graphics.draw(
				OPEN_TAB_LEFT + 32, 0, getStaticData()->getSequence(
				SpriteType::COMMON, Sequence::Common::TOOL_PALETTE_BASE ) );

			// ACR\
			const int COLUMN_PER_ROW = 3;
			const int TOOL_BTN_START_LEFT = OPEN_TAB_LEFT + 32 + 5;
			const int TOOL_BTN_INTERVAL = 34 + 5;
			const int TOOL_BTN_START_TOP = TOP + 5;

			const int TOOL_SEQ_IDS[] = {
				// 0
				Sequence::Cursor::PICK_READY,
				Sequence::Cursor::GRAB_READY,
				Sequence::Cursor::BEAT_READY,
				Sequence::Cursor::GIVE,
				Sequence::Cursor::PETTING_READY,
				// 005
				Sequence::Cursor::MIND_CONTROLLER_READY,
				Sequence::Cursor::FLAME_THROWER,
				Sequence::Cursor::CLOTH_T,
				Sequence::Cursor::CLOTH_U,
				Sequence::Cursor::NUKOSU_READY,
				// 010
				Sequence::Cursor::KNIFE_READY,
				Sequence::Cursor::PEN,
				Sequence::Cursor::CHISEL,
				Sequence::Cursor::ROTER_READY,
				Sequence::Cursor::FOOT_READY,
				// 015
				Sequence::Cursor::ROPE,
				Sequence::Cursor::LEG_BAR,
				Sequence::Cursor::SHOT_READY,
				Sequence::Cursor::EYE_BAND,
			};
#ifdef _DEBUG
			ASSERT_IT_EQUAL( SIZEOF( TOOL_SEQ_IDS ), CursorType::MAX_NUM );
#endif
				
			for( int i = 0; i < CursorType::MAX_NUM; i ++ ) {
				// x[XF\
				if( lpCursor->getType() == i ) {
					SetDrawBright( 255,200,0);
				}
				// g\
				const int FRAME_LEFT = TOOL_BTN_START_LEFT + ( i % COLUMN_PER_ROW ) * TOOL_BTN_INTERVAL;
				const int FRAME_TOP = TOOL_BTN_START_TOP + ( i / COLUMN_PER_ROW ) * TOOL_BTN_INTERVAL;
				getStaticData()->m_Basic.m_Graphics.draw(
				FRAME_LEFT, FRAME_TOP, getStaticData()->getSequence(
				SpriteType::COMMON, Sequence::Common::TOOL_BUTTON ) );
				if( lpCursor->getType() == i ) {
					SetDrawBright( 255,255,255);
				}

				int nSeqID = TOOL_SEQ_IDS[i];
					/*GCursor::getSequenceIDByType( i, StateType::STAND );
				switch( i ) {
				case CursorType::BEAT:
					nSeqID = Sequence::Cursor::BEAT_READY;
					break;
				}*/
				// ACR\
				getStaticData()->m_Basic.m_Graphics.draw(
					FRAME_LEFT +1, FRAME_TOP +1, getStaticData()->getSequence(
					SpriteType::CURSOR, //TOOL_SEQ_IDS[i] ) );
					nSeqID ) );

				// ͈
				HPLRect rRect( FRAME_LEFT, FRAME_TOP, 34, 34 );
				if( rRect.isPointInRect( vMousePos) ) {
					// ɕ\
					// TODO
					nTextResource = TextResourceType::START_TOOL + i;
					
					// 
					if( bIsLeftClick ) {
						// I
						switch( i ) {
						case CursorType::GIVE:
							this->m_nDialogType = GDialogType::ITEM;
							break;
						default:
							lpCursor->setType( i );
						}
					}

				}
			}
		}
		break;
	case PaletteType::NONE:
		// ^u\
		getStaticData()->m_Basic.m_Graphics.draw(
			CLOSE_TAB_LEFT, TOOL_TAB_TOP, getStaticData()->getSequence(
			SpriteType::COMMON, Sequence::Common::TOOL_TAB ) );
		break;
	}

	const int TAB_WIDTH = 32;
	const int TAB_HEIGHT = 96;

	const int COMMAND_TAB_TOP = 160;
	switch( this->m_nPaletteType ) {
	case PaletteType::COMMAND:
		{
			// ^u\
			getStaticData()->m_Basic.m_Graphics.draw(
				OPEN_TAB_LEFT, COMMAND_TAB_TOP, getStaticData()->getSequence(
				SpriteType::COMMON, Sequence::Common::COMMAND_TAB ) );
			// BASE
			getStaticData()->m_Basic.m_Graphics.draw(
				OPEN_TAB_LEFT + TAB_WIDTH, 0, getStaticData()->getSequence(
				SpriteType::COMMON, Sequence::Common::COMMAND_PALETTE_BASE ) );

			// ACR\
			const int CMD_BTN_START_LEFT = OPEN_TAB_LEFT + TAB_WIDTH + 4;
			const int CMD_BTN_INTERVAL = 32 + 5;
			const int CMD_BTN_START_TOP = TOP + 5;

			for( int i = 0; i < CommandType::MAX_NUM; i ++ ) {
				// {^t[\
				const int FRAME_LEFT = CMD_BTN_START_LEFT;
				const int FRAME_TOP = CMD_BTN_START_TOP + i * CMD_BTN_INTERVAL;
				getStaticData()->m_Basic.m_Graphics.draw(
				FRAME_LEFT, FRAME_TOP, getStaticData()->getSequence(
				SpriteType::COMMON, Sequence::Common::COMMAND_BUTTON ) );

				// ͈
				HPLRect rRect( FRAME_LEFT, FRAME_TOP, 120, 32 );
				if( rRect.isPointInRect( vMousePos) ) {
					// ɕ\
					// TODO
					nTextResource = TextResourceType::START_COMMAND_LIST + i;
					if( i == CommandType::EXIT ) {
						nTextResource = TextResourceType::EXIT;
					}
					
					// 
					if( bIsLeftClick ) {
						// I
						switch( i ) {
						case CommandType::CHANGE_ROOM:
							// _CAO\
							this->m_nDialogType = GDialogType::ROOM;
							/*
							switch( getStaticData()->getMapIndex()) {
							case MapIndex::P_ROOM:
								getStaticData()->startFadeOutDX( -1, 1 );
								break;
							default:
								getStaticData()->startFadeOutDX( -1, MapIndex::P_ROOM );
							}
							// Ԃ߂
							lpEnko->rollBackState( true );
							*/
							break;
						case CommandType::BACK_LOG:
							this->m_nDialogType = GDialogType::BACK_LOG;
							break;
						case CommandType::CHANGE_TIME:
							this->m_nDialogType = GDialogType::CHANGE_TIME;
							this->m_nHourTemp = getStaticData()->m_Game.getHour();
							// UAȂƁANbNŕĂ܂
							return;
							break;
						case CommandType::SAVE:
							getStaticData()->m_Save.save();
							break;
						case CommandType::CLEARANCE:
						case CommandType::CURING:
							// vitality, life񕜁B͕̑ςȂ
							break;
						case CommandType::EXIT:
							getStaticData()->setRunning( false );
							break;
						case CommandType::PURCHASE_NEUTRAL:
							// dialog
							this->m_nDialogType = GDialogType::NEUTRAL;
							break;
						default:
#ifdef _DEBUG
							ASSERT_IT_TYPE( i, "Command Type");
#endif
							;
						}
					}

				}

				// \
				DrawString( FRAME_LEFT + 5, FRAME_TOP + 5,
					COMMAND_LABELS[i], GetColor(0,0,0 ) );
			}
		}
		break;
	case PaletteType::NONE:
		// ^u\
		getStaticData()->m_Basic.m_Graphics.draw(
			CLOSE_TAB_LEFT, COMMAND_TAB_TOP, getStaticData()->getSequence(
			SpriteType::COMMON, Sequence::Common::COMMAND_TAB ) );
		break;
	} 
	


	// base͈̔
	HPLRect rBaseRect( OPEN_TAB_LEFT + TAB_WIDTH, 0, 128, 288 );
	HPLRect rToolRect( CLOSE_TAB_LEFT, TOOL_TAB_TOP, TAB_WIDTH, TAB_HEIGHT );
	HPLRect rCommandRect( CLOSE_TAB_LEFT, COMMAND_TAB_TOP, TAB_WIDTH, TAB_HEIGHT );

	switch( this->m_nPaletteType ) {
	case PaletteType::NONE:
		if( bIsLeftClick ) {

			if( rToolRect.isPointInRect( vMousePos ) ) {
				this->m_nPaletteType = PaletteType::TOOL;
			} else if( rCommandRect.isPointInRect( vMousePos ) ) {
				this->m_nPaletteType = PaletteType::COMMAND;

			}
		}
		break;
	case PaletteType::TOOL:
		if( bIsLeftClick ) {
/*			if( rBaseRect.isPointInRect( vMousePos ) ) {
				// ͈͓
				if( rCommandRect.isPointInRect( vMousePos ) ) {
					this->m_nPaletteType = PaletteType::COMMAND;
				}

			} else */{
				// ͈͊O
				// ->
				this->m_nPaletteType = PaletteType::NONE;
			}
		}
		break;
	case PaletteType::COMMAND:
		if( bIsLeftClick ) {
/*			if( rBaseRect.isPointInRect( vMousePos ) ) {
				// ͈͓
				if( rToolRect.isPointInRect( vMousePos ) ) {
					this->m_nPaletteType = PaletteType::TOOL;
				}
				
			} else */{
				// ͈͊O
				// ->
				this->m_nPaletteType = PaletteType::NONE;
			}
		}
		break;
	}

	// \L
	{
		const int COORD_X = 12;
		const int COORD_Y = 0;
		const int MERGINE = 5;
		int nHour = getStaticData()->m_Game.getHour();
		string str = HPLString::chrToStr( "%2d:00",
			 nHour );
		int nBlue = 0;
		if( ! getStaticData()->m_Game.isTheWorld()) {
			// ԏ
			if( getStaticData()->m_Game.processHour() ) {
				// Fς
				nBlue = 255;
			}
		}
		DrawString( COORD_X * TILE_SIZE, COORD_Y * TILE_SIZE + MERGINE,
			str.c_str(), GetColor(255,255,nBlue) );

	}

	// O\
	{
		const int MAX_DRAW_LINE = this->m_GameLogger.m_deqDrawLines.size();
		const int START_X = 10 + TALK_TEXT_DELTA_X;
		const int START_Y = 288 + TALK_TEXT_DELTA_Y;
		const int INTERVAL_Y = 24;
		for( int i = 0; i < MAX_DRAW_LINE; i ++ ) {
			const int Y = START_Y + i * INTERVAL_Y;
			DrawString( START_X, Y, this->m_GameLogger.m_deqDrawLines[i].c_str(), GetColor(255,255,255));
		}
	}

	// }EX
	int nTemp = this->doMouse();
	if( nTemp >= 0 && ! bIsDialogShow ) {
		nTextResource = nTemp;
	}

	// _CAO\
	nTemp = this->drawDialog( this->m_nDialogType );
	if( nTemp >= 0 ) {
		nTextResource = nTemp;
	} else if( this->m_nDialogType >= 0 ) {
		// _CAOoĂ
		// ̐͏oȂ
		nTextResource = -1;
	}


	// ܂͓Ɣ\
	if( nTextResource >= 0 ) {
		// 
		this->drawDescription( nTextResource );
	} else {
	}

	// enko̓Ɣ⃊ANV
	if( lpEnko->m_TempTalk.isEnable()) {
		lpEnko->m_TempTalk.drawAndStep();
	}



}

/**
  * ő啶Ŏs
  *
void GGUI::getLinefeed( vector<string>& vecTexts, vector<string>& vecResult,
					   int nChrsPerRow)
{
	vecResult.clear();

	
	const int MAX_ORG = vecTexts.size();
	for( int i = 0; i < MAX_ORG; i ++ ) {
		if( vecTexts[i].length() >= nChrsPerRow ) {
			int nPos = 0;
			while( nPos < vecTexts[i].length() ) {
				if( nPos + nChrsPerRow > vecTexts[i].length() ) {
					// [
					vecResult.push_back( vecTexts[i].substr( nPos ));
					break;
				} else {
					// r
					// t̒Ŏ擾
					vecResult.push_back( vecTexts[i].substr( nPos, nChrsPerRow ) );
				}
				nPos += nChrsPerRow;
			}
		} else {
			// push back
			vecResult.push_back( vecTexts[i] );
		}
	}

}
*/
/** 
  */
void GGUI::drawTalkFrame( int nAlpha) {
	const int MAX_ALPHA = 255;
	if( nAlpha < MAX_ALPHA ) {
		SetDrawBlendMode( DX_BLENDMODE_ALPHA, nAlpha );
	}
	HPLSequence* lpSeq = getStaticData()->getSequence( SpriteType::COMMON,
		Sequence::Common::TALK_FRAME );
	HPLImageInformation* lpInfo = lpSeq->getImageInformation(0);
	const int FRAME_H = lpInfo->srcRect.getHeight();

	const int WINDOW_HEIGHT = getStaticData()->m_Setting.windowHeight;

	getStaticData()->m_Basic.m_Graphics.draw(
		0, WINDOW_HEIGHT - FRAME_H,
		lpSeq);
	if( nAlpha < MAX_ALPHA ) {
		SetDrawBlendMode( DX_BLENDMODE_NOBLEND, MAX_ALPHA );
	}
}

namespace GAddCommentType {
	enum GAddCommentType {
		NO_DESC = -1,	//! \Ȃ
		NEVER_AVAILABLE = 0,	//! ps
		UNLOCK,			//! AbN
		AVAILABLE,		//! w\
		ADD,			//! ǉw
		FULL,			//! ȏǉs
	};
}
int convertFromTypeStateToAddCommentType(int nTypeState ) {
	switch( nTypeState ) {
	case GTypeState::NONE:
	case GTypeState::NO_USE:
		return GAddCommentType::NO_DESC;
	case GTypeState::NEVER_AVAILABLE:
		return GAddCommentType::NEVER_AVAILABLE;
	case GTypeState::LOCKED:
		return GAddCommentType::UNLOCK;
	case GTypeState::AVAILABLE:
		return GAddCommentType::AVAILABLE;
	case GTypeState::PURCHASED:
		return GAddCommentType::ADD;
	}
	// s
#ifdef _DEBUG
	ASSERT_IT_TYPE( nTypeState, "");
#endif
	return GAddCommentType::NO_DESC;
}

/** draw description
  */
void GGUI::drawDescription( int nResourceID ) {
	// text frame
	this->drawTalkFrame( 255 );

	vector<string> vecTexts = this->m_TextResourceManager.get( nResourceID )->m_vecTexts;

	// draw text
	drawTexts( vecTexts, ScenarioType::TALK );

	int nAddComment = -1;
	//! p
	int nMoney = -1;

	int nNum = 0;
	int nTypeStateIndex = -1;
	int nBase = -1;

	if( nResourceID >= TextResourceType::START_NEUTRAL ) {
		nBase = TextResourceType::START_NEUTRAL;
		nTypeStateIndex = GTypeStateIndex::NEUTRALS;
		
		int nNeutralType = nResourceID - nBase;
		nNum = getStaticData()->m_Save.m_ResearcherData.m_NeutralData.get( nNeutralType )->getNum();
		if( nNum >= 1 ) {
			// 1ȏ㎝Ă
			// ĂȂ
			nAddComment = GAddCommentType::FULL;
		}
	} else if( nResourceID >= TextResourceType::START_ITEM ) {
		nBase = TextResourceType::START_ITEM;
		nTypeStateIndex = GTypeStateIndex::ITEMS;

		int nItemType = nResourceID - nBase;
		nNum = getStaticData()->m_Save.m_ResearcherData.getItemNum( nItemType );

	} else if( nResourceID >= TextResourceType::START_ROOM ) {
		nBase = TextResourceType::START_ROOM;
		nTypeStateIndex = GTypeStateIndex::MAPS;

	} else if( nResourceID >= TextResourceType::START_TOOL ) {
		nBase = TextResourceType::START_TOOL;
		nTypeStateIndex = GTypeStateIndex::CURSORS;
	}

	if( nTypeStateIndex >= 0 ) {
		int nType = nResourceID - nBase;
		int nTypeState = GTypeState::NONE;
		nTypeState = getStaticData()->m_Save.m_ResearcherData.getTypeState(
				nTypeStateIndex, nType );
		if( nAddComment < 0 ) {
			nAddComment = convertFromTypeStateToAddCommentType(
				nTypeState );
		}
		int nMoneyInfoContainerType = getMoneyInfoContainerTypeFromTypeStateIndex(
			nTypeStateIndex );

		GMoneyInfo* lpInfo = getStaticData()->m_MoneyInfoManager.m_aryMoneyInfoContainers[ nMoneyInfoContainerType].get(
			nType );
		nMoney = nTypeState <= GTypeState::LOCKED ? 
			lpInfo->m_nUnlock : lpInfo->m_nBuy;
	}

	// w֘A̕\
	string strExtra;

	bool bIsDraw = true;
	switch( nAddComment ) {
	case GAddCommentType::NO_DESC:
		bIsDraw = false;
		break;
	case GAddCommentType::NEVER_AVAILABLE:
		strExtra = string("ypsz");
		break;
	case GAddCommentType::UNLOCK:
		strExtra = HPLString::chrToStr( "yJF$%dz", nMoney );
		break;
	case GAddCommentType::AVAILABLE:
		strExtra = HPLString::chrToStr( "ywF$%dz", nMoney);
		break;
	case GAddCommentType::ADD:
		{
			string strAdd = HPLString::chrToStr( "ywF$%dz", nMoney);

			if( nNum >= 0 ) {
				strAdd += HPLString::chrToStr( ":%d", nNum );
			}
			strExtra = strAdd;
		}
		break;
	case GAddCommentType::FULL:
		{
			string strAdd = HPLString::chrToStr( "yMAXz");

			if( nNum >= 0 ) {
				strAdd += HPLString::chrToStr( ":%d", nNum );
			}
			strExtra = strAdd;
		}
		break;
	default:
#ifdef _DEBUG
		ASSERT_IT_TYPE( nAddComment, "");
#endif 
		bIsDraw = false;
		;
	}
	if( bIsDraw ) {
		DrawString( 40, 460, strExtra.c_str(), GetColor(200,200,10));
	}
}

/** draw text common
  */
void GGUI::drawTexts( vector<string> vecTexts, int nScenarioItemType ) {
	vector<string> vecLinefeeded;
	// [ŉs
	HPLString::getLinefeed( vecTexts, vecLinefeeded,
		nScenarioItemType == ScenarioType::TALK ? TALK_CHRS_PER_LINE : EMOTION_CHRS_PER_LINE);

	HPLSequence* lpSeq = getStaticData()->getSequence( SpriteType::COMMON,
		Sequence::Common::TALK_FRAME );
	HPLImageInformation* lpInfo = lpSeq->getImageInformation(0);
	const int FRAME_H = lpInfo->srcRect.getHeight();

	const int WINDOW_HEIGHT = getStaticData()->m_Setting.windowHeight;

	const int TALK_FRAME_Y = WINDOW_HEIGHT - FRAME_H;

	int nLeft = nScenarioItemType == ScenarioType::TALK ? TALK_TEXT_DELTA_X : 128;
	const int MAX_LINES = vecLinefeeded.size();
	for( int i = 0; i < MAX_LINES; i ++ ) {
		const int X = nLeft;
		const int Y = TALK_FRAME_Y + TALK_TEXT_DELTA_Y +
			i * TALK_TEXT_INTERVAL_Y;
		DrawString( X, Y, vecLinefeeded[i].c_str(),
			GetColor(255,255,255));
	}
}

