#pragma once
#include <HPLDXLib.h>
#include <hpllib/game/AbstractGame.h>
#include <hpllib/action/HPLScroller.h>
#include <hpllib/math/HPLMath.h>

#include "GEnum.h"

//! 1ԂɑΉt[
static const int HOUR_STEP_INTERVAL = 5000;
static const int HOUR_STEP = 1;

static const int HOUR_MAX = 24;
static const int NIGHT_HOUR = 22;	
static const int MORNING_HOUR = 7;	//! N鎞

static const int MAX_SAME_COUNT = 10;	//! 10ȏ㓯ƂĂ{[iX͔Ȃi{[iX1j

/** Q[֘A
  */
class GGame: public AbstractGame {
public:
private:
	//! 
	int m_nHour;
	HPLCounter m_cntHourStepInterval;

	//! {[iXsJԂƁAʂĂ
	int m_nSameCheck;
public:
	int getHour(){ return this->m_nHour; }
	void setHour( int nHour ) {
		// circulation
		nHour = HPLMath::adjustCirculation( nHour, 24 );
		this->m_nHour = nHour;
	}
	/** @retval	true	̃XebvŎς
	  */
	bool processHour();

public:
	GGame():AbstractGame(){
		this->m_nHour = MORNING_HOUR;
		this->m_cntHourStepInterval.setWaitFrameNum( HOUR_STEP_INTERVAL );
		this->m_nSameCheck = 0;
	}
	virtual ~GGame(){}
public:
	void resetHour() {
		this->m_nHour = MORNING_HOUR;
		this->m_cntHourStepInterval.reset();
	}
};
