#include "GItemManager.h"
#include "GStaticData.h"

#include <hpllib/system/HPLFile.h>
#include <hpllib/action/HPL3DActionMoveTool.h>

GItemManager::GItemManager() : HPLObjectManager() {
	// load label
//	this->m_vecItemNames = HPLFile::loadStringFromFile( "data\\image\\Item\\ItemLabel.txt", true );
}
void GItemManager::process(bool bIsMove, bool bIsAI) {
	HPLRect rGameRange = getStaticData()->getGameRange();

	// player
	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();


	int nMapIndex = getStaticData()->getMapIndex();

	for( list<GItem*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		)
	{
		GItem* lpItem = *it;

		bool bIsDieWhenOutterRange = true;
/*		if( getStaticData()->isBossMap( nMapIndex ) ) {
			bIsDieWhenOutterRange = false;
		} */

		if( bIsDieWhenOutterRange ) {
			if( ! rGameRange.isShare( lpItem->getHitArea()) ) {
				lpItem->setAlive( false );
			}
		}
		

		if( lpItem->isAlive() ) {
			// move
			if( bIsMove ) {
				const float RESIST = getStaticData()->m_Setting.resist;
				const float GRAVITY = getStaticData()->m_Setting.gravity;
				// move
				HPL3DActionMoveTool::common3DMove( 
					lpItem, & lpItem->m_3DInfo,
					true, RESIST, GRAVITY );
				if( bIsAI ) {
					this->algorithm( lpItem );
				}
				this->checkHitToPlayer( lpItem );
			}

		}

		if( lpItem->isAlive()) {
//			lpItem->draw();
			it ++;
		} else {
			delete lpItem;
			it = this->getList()->erase( it );
		}
	}
}
GItem* GItemManager::create(int nType, HPLVector vCenter,
							int nAddType )
{
	GItem* lpItem = new GItem( nType );
	lpItem->setCenter( vCenter );
	HPL3DActionMoveTool::setCenter3D( lpItem, &lpItem->m_3DInfo, 
		vCenter.getX(), vCenter.getY(), 0 );
	switch( nAddType ) {
	case HPL::AddType::LIST:
		this->getList()->push_back( lpItem );
		break;
	case HPL::AddType::RESERVE:
		this->addReserve( lpItem );
		break;
	}
	return lpItem;
}

void GItemManager::algorithm(GItem* lpItem) {
}

/********************************************************************** hit to player
  */
bool GItemManager::checkHitToPlayer( GItem* lpItem ) {
	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();
	HPLRect rPlayerHitAreaXY = lpEnko->getHitArea();
	HPLRect rItemHitAreaXY = lpItem->getHitArea();

	if( rPlayerHitAreaXY.isShare( rItemHitAreaXY ) ) {	// hit area
		// item
		HPLRect rItemHitAreaXZ = HPL3DActionMoveTool::getLaidHitAreaXZ(
			lpItem, &lpItem->m_3DInfo );
		// player
		HPLRect rPlayerHitAreaXZ = HPL3DActionMoveTool::getStandHitAreaXZ(
			lpEnko, &lpItem->m_3DInfo, Z_THRESHOLD );

		if( rItemHitAreaXZ.isShare( rPlayerHitAreaXZ ) ) {
			// get item
//			lpEnko->getItem( lpItem->getType());
			return true;
		}
	}
	return false;
}
