#include "GMoneyInfo.h"

#include "GStaticData.h"
#include <hpllib/system/HPLFile.h>
#include <hpllib/general/HPLString.h>

using namespace std;

bool GMoneyInfoContainer::load( const char* lpszFilePath ) {
	this->m_mapMoneyInfos.clear();


	vector<string> vecLines = HPLFile::loadStringFromFile( lpszFilePath, true );


	const int MAX_LINES = vecLines.size();
	for( int i = 0; i < MAX_LINES; i ++ ) {
		vector<string> vecItems = HPLString::split( vecLines[i], ",");
		const int MAX_NUM = vecItems.size();

		if( MAX_NUM < GMoneyInfoType::MAX_NUM ) {
#ifdef _DEBUG
			HPLError::assertIt( false, "Too few arguments");
#endif
			continue;
		}

		GMoneyInfo info;
		info.m_strName = HPLString::trim( vecItems[ GMoneyInfoType::NAME ] );
		info.m_nID = atoi( vecItems[ GMoneyInfoType::ID ].c_str());
		info.m_nUnlock = atoi( vecItems[ GMoneyInfoType::UNLOCK].c_str());
		info.m_nBuy = atoi( vecItems[ GMoneyInfoType::BUY].c_str());

		if( this->m_mapMoneyInfos.find( info.m_nID ) != this->m_mapMoneyInfos.end() ) {
			// ɑ݂
#ifdef _DEBUG
			HPLError::assertIt( false, "Duplicate");
#endif
		}
		this->m_mapMoneyInfos[ info.m_nID] = info;
	}
}

