#pragma once

#include <hpllib/system/HPLError.h>

#include <map>
#include <string>
using namespace std;

namespace GMoneyInfoType {
	enum GMoneyInfoType {
		NAME,
		ID,
		UNLOCK,
		BUY,
		MAX_NUM
	};
}
/**
  z
  * format:
  * Name, ID, Unlock, Buy
  *
  * Name:OBgpȂ̂ŕ₷悤ɂ
  * ID:ʂԍBeTypeԍƈv
  * Unlock:unlockA܂͊ĴɕKvȉi
  * Buy:ŵɕKvȉiBl͊ȂǂœvZ
  * 
  * ex:
  * Bed, 0, 10000,	500
  */
class GMoneyInfo {
public:
	string m_strName;
	int m_nID;
	int m_nUnlock;
	int m_nBuy;
public:
	GMoneyInfo() {
		this->m_nID = -1;
		this->m_nUnlock = 0;
		this->m_nBuy = 0;
	}
	~GMoneyInfo(){}
};

class GMoneyInfoContainer {
public:
private:
	map<int, GMoneyInfo> m_mapMoneyInfos;
public:
	GMoneyInfo* get( int nID ) {
		map<int, GMoneyInfo>::iterator it = this->m_mapMoneyInfos.find( nID );
		if( it == this->m_mapMoneyInfos.end() ) {
#ifdef _DEBUG
			HPLError::assertIt( false, "");
#endif
			return NULL;
		}
		return &this->m_mapMoneyInfos[nID];
	}
public:
	GMoneyInfoContainer(){}
	~GMoneyInfoContainer(){}

public:
	bool load( const char* lpszFilePath );
};
