#include "GNeutralData.h"
#include "GStaticData.h"
#include <iostream>
#include <fstream>
using namespace std;

#include <hpllib/general/HPLString.h>
#include <hpllib/system/HPLFile.h>

static const char NEUTRALS_FILE_PATH[] = "neutrals.sav";
void GNeutralData::setAsDefault() {
	this->clear();
	// ŏQbgł

	// TODO

}
bool GNeutralData::load() {
	this->setAsDefault();
	vector<string> vecLines;
	try {
		vecLines = HPLFile::loadStringFromFile( NEUTRALS_FILE_PATH , true );

		const int MAX_LINES = vecLines.size();
		for( int i = 0; i < MAX_LINES; i ++ ) {
			vector<string> vecItems = HPLString::split( vecLines[i], ",");
			if( vecItems.size() < 4 ) {
#ifdef _DEBUG
				HPLError::assertIt( false, "");
#else
				continue;
#endif
			}
			int nID = atoi( vecItems[0].c_str());
			
			GNeutralItemSet* lpSet = this->get(nID );
			if( lpSet == NULL ) {
#ifdef _DEBUG
				HPLError::assertIt( false, "");
#else
				continue;
#endif
			}
			GNeutralItem item;
			item.m_nType = nID;
			item.m_nMapIndex = atoi( vecItems[ GNeutralItemDataType::MAP_INDEX].c_str());
			item.m_vCenter.x = atoi( vecItems[ GNeutralItemDataType::CENTER_X].c_str());
			item.m_vCenter.y = atoi( vecItems[ GNeutralItemDataType::CENTER_Y].c_str());
			item.m_nZ = atoi( vecItems[ GNeutralItemDataType::Z].c_str());
			lpSet->add(item );
		}
	}catch( ... ) {
		HPLError::msg( "Warning", MB_OK, "[hsB");
		if( this->save() ) {
			// ĂZ[uł̂ŗǂƂ
			return true;
		} else {
			return false;
		}
	}
	return true;
}
bool GNeutralData::save() {
	ofstream ofs( NEUTRALS_FILE_PATH );
	if( ! ofs.is_open()) {
		HPLError::msg( "Warning", MB_OK, "Z[usBis͕ۑ܂");
		return false;
	}
	for( int i = 0; i < Sequence::Neutral::MAX_NUM; i ++ ) {
		const int MAX_ITEM_NUM = this->m_aryNeutralItemSets[i].getNum();

		for( int j = 0; j < MAX_ITEM_NUM; j ++ ) {
			GNeutralItem* lpItem = this->m_aryNeutralItemSets[i].get(j);//m_vecNeutralItems[j];
			string str = HPLString::chrToStr(
				"%d,%d,%d,%d,%d\n",
				lpItem->m_nType,
				lpItem->m_nMapIndex,
				lpItem->m_vCenter.x,
				lpItem->m_vCenter.y,
				lpItem->m_nZ );
			ofs.write( str.c_str(), str.length() );
				
			
		}
	}
	ofs.close();
	return true;
}
