#pragma once

#include <hpllib/math/HPLVectorInt.h>
#include <vector>
#include "GNeutral.h"
using namespace std;

/** Z[uf[^̃J}؂f[^
  */
namespace GNeutralItemDataType {
	enum GNeutralItemDataType {
		TYPE,
		MAP_INDEX,
		CENTER_X,
		CENTER_Y,
		Z,
	};
}

/** wςNeutral
  * LIFT`łȂ̂ɂẮA
 */
class GNeutralItem {
public:
	//! type
	int m_nType;
	//! uĂ镔
	int m_nMapIndex;
	// z
	//HPL3DInfo m_3DInfo;
	int m_nZ;
	// xy center
	//HPLVector m_vCenter;
	HPLVectorInt m_vCenter;

	//! ݒuǂ
	bool m_bIsSettle;
public:
	GNeutralItem() {
		this->m_nType = -1;
		this->m_nZ = 0;
		this->m_nMapIndex = -1;
		this->m_bIsSettle = false;
	}
	~GNeutralItem(){}

};
class GNeutralItemSet {
private:
	//! 
	int m_nType;
	vector<GNeutralItem> m_vecNeutralItems;
public:
	void add( GNeutralItem item ) {
		this->m_vecNeutralItems.push_back( item );
	}
	GNeutralItem* get( int nIndex ) {
		return &this->m_vecNeutralItems[nIndex];
	}
	int getNum() { return this->m_vecNeutralItems.size();}
	vector<GNeutralItem>* getList() { return &this->m_vecNeutralItems;	}
	
public:
	GNeutralItemSet() {
		this->m_nType = -1;
	}
	~GNeutralItemSet() {
		this->clear();
	}
	void clear() {
		this->m_vecNeutralItems.clear();
	}
};
/** if[^
  */
class GNeutralData {
public:
private:
	//! w\
	int m_nTypeState[ Sequence::Neutral::MAX_NUM];
	GNeutralItemSet m_aryNeutralItemSets[ Sequence::Neutral::MAX_NUM];
public:
	GNeutralItemSet* get( int nType) {
		if( nType < 0 || nType >= Sequence::Neutral::MAX_NUM ) {
#ifdef _DEBUG
			ASSERT_IT_INDEX( nType, 0, Sequence::Neutral::MAX_NUM );
#endif
			return NULL;
		}
		return &this->m_aryNeutralItemSets[nType];
	}
public:
	GNeutralData() {
		for( int i = 0; i < Sequence::Neutral::MAX_NUM; i ++ ) {
		}
		this->setAsDefault();
	}
	~GNeutralData() {
		this->clear();
	}
	void setAsDefault();
	bool load();
	bool save();
	void clear() {
		for( int i = 0; i < Sequence::Neutral::MAX_NUM; i ++ ) {
			this->m_aryNeutralItemSets[i].clear();
		}

	}
};
