#include "GNeutralManager.h"

#include "GStaticData.h"
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPLObjectCollisionCheckTool.h>
#include <hpllib/system/HPLFile.h>
#include <hpllib/general/HPLString.h>

using namespace std;

/** settinǂݍ
  */
bool GNeutralSetting::loadSettings( const char* lpszSettingFilePath, GNeutralSetting arySettings[] ) {
	vector<string> vecLines;
	try {
		vecLines = HPLFile::loadStringFromFile( lpszSettingFilePath, true );
	} catch( ... ) {
#ifdef _DEBUG
		HPLError::assertIt( false, "Failed to load Neutral Setting[%s]",
			lpszSettingFilePath );
#endif
		return false;
	}
	// [hłǂ
	bool aryChecks[ Sequence::Neutral::MAX_NUM];
	for( int i = 0; i < Sequence::Neutral::MAX_NUM; i ++ ) {
		aryChecks[i] = false;
	}

	const char GRAB_TYPE_LABELS[][64] = {
		"NO_GRAB",
		"LIFT",
		"SLIDE",
	};
#ifdef _DEBUG
	ASSERT_IT_EQUAL( SIZEOF( GRAB_TYPE_LABELS), GGrabType::MAX_NUM );
#endif
	const char CLASS_TYPE_LABELS[][64] = {
		"TOOL",
		"TOY",
		"FURNITURE",
	};
#ifdef _DEBUG
	ASSERT_IT_EQUAL( SIZEOF( CLASS_TYPE_LABELS), GNeutralClassType::MAX_NUM );
#endif
	
	const char HIT_AREA_3D_TYPE_LABELS[][64] = {
		"STAND",
		"LAID",
	};
#ifdef _DEBUG
	ASSERT_IT_EQUAL( SIZEOF( HIT_AREA_3D_TYPE_LABELS), HitArea3DType::MAX_NUM );
#endif

	const int MAX_LINES = vecLines.size();
	for( int i = 0; i < MAX_LINES; i ++ ) {
		vector<string> vecItems = HPLString::split( vecLines[i], ",");
		if( vecItems.size() < GNeutralSettingType::MAX_NUM ) {
#ifdef _DEBUG
			HPLError::assertIt( false, "%s", vecLines[i].c_str());
#else
			continue;
#endif
		}

		try {
			// get type num
			int nType = atoi( vecItems[ GNeutralSettingType::TYPE].c_str());
			arySettings[nType].m_nType = nType;

			for( int j = 0; j < GNeutralSettingType::MAX_NUM; j ++ ) {
				string strItem = HPLString::trim( vecItems[j] );
				switch( j ) {
				case GNeutralSettingType::NAME:
					arySettings[nType].m_strName = strItem;
					break;
				case GNeutralSettingType::TYPE:
					break;
				case GNeutralSettingType::HIT_RECT_X:
					arySettings[nType].m_rHitRect.setX( atof( strItem.c_str()));
					break;
				case GNeutralSettingType::HIT_RECT_Y:
					arySettings[nType].m_rHitRect.setY( atof( strItem.c_str()));
					break;
				case GNeutralSettingType::HIT_RECT_W:
					arySettings[nType].m_rHitRect.setWidth( atof( strItem.c_str()));
					break;
				case GNeutralSettingType::HIT_RECT_H:
					arySettings[nType].m_rHitRect.setHeight( atof( strItem.c_str()));
					break;
				case GNeutralSettingType::GRAB_TYPE:
					{
						int nGrabType = -1;
						for( int k = 0; k < GGrabType::MAX_NUM; k ++ ) {
							if( HPLString::equals( strItem, GRAB_TYPE_LABELS[ k] ) ) {
								nGrabType = k;
								break;
							}
						}
						if( nGrabType >= 0 ) {
							arySettings[nType].m_nGrabType = nGrabType;
						} else {
#ifdef _DEBUG
							HPLError::assertIt( false, "Invalid GrabType");
#endif
						}
					}
					break;
				case GNeutralSettingType::CLASS_TYPE:
					{
						int nClassType = -1;
						for( int k = 0; k < GNeutralClassType::MAX_NUM; k ++ ) {
							if( HPLString::equals( strItem, CLASS_TYPE_LABELS[ k] ) ) {
								nClassType = k;
								break;
							}
						}
						if( nClassType >= 0 ) {
							arySettings[nType].m_nClassType = nClassType;
						} else {
#ifdef _DEBUG
							HPLError::assertIt( false, "Invalid ClassType");
#endif
						}
					}
					break;
				case GNeutralSettingType::HIT_AREA_3D_TYPE:
					{
						int nHitArea3DType = -1;
						for( int k = 0; k < HitArea3DType::MAX_NUM; k ++ ) {
							if( HPLString::equals( strItem, HIT_AREA_3D_TYPE_LABELS[ k] ) ) {
								nHitArea3DType = k;
								break;
							}
						}
						if( nHitArea3DType >= 0 ) {
							arySettings[nType].m_nHitArea3DType = nHitArea3DType;
						} else {
#ifdef _DEBUG
							HPLError::assertIt( false, "Invalid HitArea3DType");
#endif
						}
					}
					break;
				default:
#ifdef _DEBUG
					ASSERT_IT_TYPE(j, "");
#else
					continue;
#endif
				}// end of switch j
			} // end of for neutral setting types
		} catch( ... ) {
#ifdef _DEBUG
			HPLError::assertIt( false, "Invalid format");
#else
			continue;
#endif
		}
	}
	return true;
}

GNeutralManager::GNeutralManager() : HPLObjectManager<GNeutral>(){
	GNeutralSetting::loadSettings( "data\\image\\Neutral\\NeutralSetting.txt",
		this->m_arySettings);

	this->m_NameSet.load( "data\\image\\Neutral\\NeutralToolName.txt");

	// load names
	this->m_vecNames = HPLFile::loadStringFromFile( "data\\image\\Neutral\\NeutralLabel.txt", true);
}

void GNeutralManager::process(bool bIsMove, bool bIsAI) {

	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();

//	lpEnko->m_bIsCKey = false;

	HPLRect rGameRange = getStaticData()->getGameRange();
	for( list<GNeutral*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		)
	{
		GNeutral* lpNeutral = *it;
		if( ! rGameRange.isShare( lpNeutral->getHitArea()) ) {
			lpNeutral->setAlive( false );
		}

		if( lpNeutral->isAlive() ) {
			// move
			if( bIsMove ) {
				const float RESIST = getStaticData()->m_Setting.resist;
				const float GRAVITY = getStaticData()->m_Setting.gravity;
				// move
				HPL3DActionMoveTool::common3DMove( 
					lpNeutral, & lpNeutral->m_3DInfo,
					true, RESIST, GRAVITY );
				if( bIsAI ) {
					this->algorithm( lpNeutral );
				}

				// vC[蔻
				this->checkHitToEnko( lpNeutral, lpEnko );
//				this->checkHitToEnemy( lpNeutral );
			}


		}

		if( lpNeutral->isAlive()) {
//			lpNeutral->draw();
			it ++;
		} else {
			delete lpNeutral;
			it = this->getList()->erase( it );
		}
	}
}
bool GNeutralManager::checkHitToEnko( GNeutral* lpNeutral, GEnko* lpEnko ) {
	if( lpEnko->isHeld() ) {
		return false;
	}
	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();
	if( lpCursor->m_GrabInfo.getID() == lpEnko->getID() ) {
		// vC[ł
		// skip
		return false;
	}

	GNeutralSetting* lpSetting = this->getSetting( lpNeutral->getType());

	// ̂
	CollisionState stResultX, stResultZ;
	const float BOUNCE_RATE_X = 1;
	const float BOUNCE_RATE_Z = 1;
	// ̂
	HPLObjectCollisionCheckTool::checkObjectCollision3D(
		lpEnko, &lpEnko->m_3DInfo,
		lpNeutral, &lpNeutral->m_3DInfo, 
		stResultX, stResultZ,
//		&getStaticData()->m_BlockManager,
		Z_THRESHOLD,
		HitArea3DType::STAND,
		lpSetting->m_nHitArea3DType,//HitArea3DType::LAID,
		BOUNCE_RATE_X, BOUNCE_RATE_Z);

/*	switch( lpEnko->m_AIInfo.getAIPattern()) {
	case AIPattern::N_WALK:
		if( lpEnko->getTrigger()->isHitWall3D()) {
			// ~܂
		}
		break;
	}*/
	return stResultX.isHitX != 0 || stResultZ.isHitY != 0;
}

GNeutral* GNeutralManager::create(int nType, HPLVector vCenter,
								  int nAddType ) 
{
	GNeutral* lpNeutral = new GNeutral( nType );

	lpNeutral->setCenter( vCenter );

	HPL3DActionMoveTool::setCenter3D( lpNeutral, &lpNeutral->m_3DInfo, vCenter.getX(), vCenter.getY(), 
		0 );

	switch( nAddType ) {
	case HPL::AddType::LIST:
		this->getList()->push_back( lpNeutral );
		break;
	case HPL::AddType::RESERVE:
		this->addReserve( lpNeutral );
		break;
	}

	return lpNeutral;
}
/** ʏ
  */
void GNeutralManager::algorithm(GNeutral* lpNeutral) {
	int st = lpNeutral->getState()->getState();
	HPLSequence* lpSeq = lpNeutral->getSequence();

}

GNeutral* GNeutralManager::getByType( int nType ) {
	for( list<GNeutral*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		it ++ )
	{
		GNeutral* lpNeutral = *it;
		if( lpNeutral->getType() == nType ) {
			return lpNeutral;
		}
	}
	return NULL;
}
GNeutral* GNeutralManager::getByID( long lID ) {
	for( list<GNeutral*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		it ++ )
	{
		GNeutral* lpNeutral = *it;
		if( lpNeutral->getID() == lID ) {
			return lpNeutral;
		}
	}
	return NULL;
}


/** S
  */
void GNeutralManager::grab( GNeutral* lpNeutral, GEnko* lpEnko ) {
	lpNeutral->setHolding( true );
	lpEnko->setHoldEnemyType( lpNeutral->getType());
	lpEnko->setHeld( true );
	// Œ
	int nFaceDirection = FaceDirection::LEFT;
	switch( lpNeutral->getType()) {
	case Sequence::Neutral::BONDAGE_WALL:
		lpEnko->changeState( StateType::BIND );
		break;
	case Sequence::Neutral::BED:
	case Sequence::Neutral::SURGEON_BED:
		lpEnko->changeState( StateType::HOLD );
		nFaceDirection = FaceDirection::RIGHT;	//! right(ɑ
		break;
	case Sequence::Neutral::BUNBETSU:
		lpEnko->changeState( StateType::BIND );
		break;
	case Sequence::Neutral::BATH:
		lpEnko->changeState( StateType::BIND );
		nFaceDirection = FaceDirection::RIGHT;	
		break;
	case Sequence::Neutral::HOOK:
		lpEnko->changeState( StateType::BIND );
		nFaceDirection = FaceDirection::LEFT;
		break;
	default:
#ifdef _DEBUG
		ASSERT_IT_TYPE( lpNeutral->getType(), "Neutral Type");
#endif
		;
	}
	lpEnko->setFaceDirection( nFaceDirection );

	// get tool name
	vector<string>* lpvecNameSet = this->m_NameSet.getNameContainer( lpNeutral->getType());
#ifdef _DEBUG
	ASSERT_IT_NULL( lpvecNameSet );
	HPLError::assertIt( lpvecNameSet->size()>= 1, "" );
#endif
	// add log
	string str = HPLString::chrToStr( "[%s]", lpvecNameSet->at(0).c_str());
	
	if( lpvecNameSet->size() >= 2 ) {
		int nAt = NameIndex::ACTION;
		str += HPLString::chrToStr( "[%s]", lpvecNameSet->at(nAt ).c_str());
	}

	// add to log
	getStaticData()->m_GUI.m_GameLogger.addDrawLine( str );
	
}

/** 
  */
void GNeutralManager::release( GNeutral* lpNeutral, GEnko* lpEnko ) {
	if( lpNeutral == NULL ) {
		// ͂łzT
		lpNeutral = this->getByType( lpEnko->getHoldEnemyType());
		
	}
	if( lpNeutral ) {
		lpNeutral->setHolding( false );
	}
	lpEnko->setHeld( false );
	lpEnko->setHoldEnemyType(-1);
}

/** Sʒu擾iNeutral̒SW̍j
  */
HPLVector GNeutralManager::getHoldDeltaFromCenter( GNeutral* lpNeutral ) {
	switch( lpNeutral->getType() ) {
	case Sequence::Neutral::BONDAGE_WALL:
	case Sequence::Neutral::BUNBETSU:
		return HPLVector(0,0);
	case Sequence::Neutral::BED:
	case Sequence::Neutral::SURGEON_BED:
		return HPLVector( -10, -20 );
	case Sequence::Neutral::BATH:
		return HPLVector( -16,-16 );
	case Sequence::Neutral::HOOK:
		return HPLVector(0,64);
	default:
#ifdef _DEBUG
		ASSERT_IT_TYPE( lpNeutral->getType(), "hold delta from center: neutral type");
#endif
		;
	}
	return HPLVector(0,0);
}

/** w肵PointɂЂNeutraliŏɈ̂݁Bj
  * Ƃ肠S`FbN邪AZԏ́iOj1擾
  * @retval	NULL	Ȃ
  */
GNeutral* GNeutralManager::getByPointInRect( HPLVector vPoint ) {
	float fZ = -99999;
	GNeutral* lpGet = NULL;

	for( list<GNeutral*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		it ++ )
	{
		// skip?
		GNeutral* lpNeutral = *it;

		if( ! lpNeutral->isAlive()) {
			continue;
		}
		HPLRect rAreaXY = lpNeutral->getHitArea();
		if( ! rAreaXY.isPointInRect( vPoint ) ) {
			continue;
		}
		if( lpNeutral->m_3DInfo.getZ() > fZ ) {
			lpGet = lpNeutral;
			fZ = lpNeutral->m_3DInfo.getZ();
		}
	}	
	return lpGet;
}
