#include "GObjectManager.h"
#include <algorithm>
#include "GStaticData.h"

#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPL3DRailMoveTool.h>

using namespace std;


GObjectManager::GObjectManager() {
}

void GObjectManager::setup() {
	this->m_Enko.setup();
	this->m_Cursor.setup();
}
void GObjectManager::clear() {
	this->m_EnemyManager.clear();
	this->m_EffectManager.clear();
	this->m_ShotManager.clear();
	this->m_ItemManager.clear();
	this->m_NeutralManager.clear();
	this->m_AchievementManager.clear();
}
float getZ( HPLShootingObject* lpObj ) {
	return getStaticData()->get3DInfo( lpObj )->getZ();
}
bool front(HPLShootingObject* a, HPLShootingObject* b){
	float fZA = getZ( a );
	float fZB = getZ( b );
	return fZA < fZB;
}

void GObjectManager::draw() {

	vector<HPLShootingObject*> vecObjects;

/*	// draw blood
	for( list<GNeutral*>::iterator it = this->m_NeutralManager.getList()->begin();
		it != this->m_NeutralManager.getList()->end();
		it ++ )
	{
		GNeutral* lpNeutral = *it;
		switch( lpNeutral->getType()) {
		case Sequence::Neutral::BLOOD:
			lpNeutral->draw();
			break;
		}
	}*/
	// add player
	GCursor* lpCursor = this->getCursor();
	GEnko* lpEnko = this->getEnko();
	if( lpCursor->m_GrabInfo.isEnable() && lpCursor->m_GrabInfo.getObjectType() == ObjectType::PLAYER ) {
		// \
		vecObjects.push_back( lpEnko );
	} else if( lpEnko->isHeld() ) {
		// \Ȃ
	} else {
		vecObjects.push_back( lpEnko );
	}

	vecObjects.insert( vecObjects.begin(), this->m_EnemyManager.getList()->begin(), this->m_EnemyManager.getList()->end() );
	vecObjects.insert( vecObjects.begin(), this->m_EffectManager.getList()->begin(), this->m_EffectManager.getList()->end() );
	vecObjects.insert( vecObjects.begin(), this->m_ItemManager.getList()->begin(), this->m_ItemManager.getList()->end() );
//	vecObjects.insert( vecObjects.begin(), this->m_ShotManager.getList()->begin(), this->m_ShotManager.getList()->end() );
	vecObjects.insert( vecObjects.begin(), this->m_NeutralManager.getList()->begin(), this->m_NeutralManager.getList()->end() );

	sort( vecObjects.begin(), vecObjects.end(),front );

	// ʊÔ͕̂\Ȃ
	HPLRect rMerginedRange = getStaticData()->getMerginedGameRange();
	for( vector<HPLShootingObject*>::iterator it = vecObjects.begin();
		it != vecObjects.end(); it ++ )
	{
		HPLShootingObject* lpObject = *it;
		
/*		if( ! rMerginedRange.isShare( lpObject->getArea()) ) {
			continue;
		}*/
		switch( lpObject->getObjectType()) {
		case ObjectType::PLAYER:	((GEnko*)lpObject)->draw();	break;
		case ObjectType::ENEMY:	((GEnemy*)lpObject)->draw();	break;
		case ObjectType::ITEM:	((GItem*)lpObject)->draw();	break;
		case ObjectType::EFFECT:	((GEffect*)lpObject)->draw();	break;
		case ObjectType::SHOT:	((GShot*)lpObject)->draw();	break;
		case ObjectType::NEUTRAL:
			((GNeutral*)lpObject)->draw();
			break;
		default:
#ifdef _DEBUG
			ASSERT_IT_TYPE( lpObject->getObjectType(), "Object Type")
#endif
			;
		}

	}

}


/** Wv
  * vVel.y = -fAbsoluteSpeed, vCen.y -= fAbsoluteSpeed {
  * @param[in]	fAbsoluteSpeed	Wvx̐ΒlB
  * 
  */
void GObjectManager::jump( HPLShootingObject* lpObject, float fAbsoluteSpeed ) {
	lpObject->m_vVelocityAngle.setY( -fAbsoluteSpeed );
	lpObject->m_vCenter.add( 0, -fAbsoluteSpeed );
	lpObject->getTrigger()->setTrigger( TriggerType::ON_THE_GROUND, false );
}

/** Jn
  * @param[in]	nNextAIPattern	AIp^[
  */
void GObjectManager::startWalk( HPLShootingObject* lpObject, HPL3DInfo* lp3DInfo,
							   HPLAIInfo* lpAIInfo,
	HPLVector vGoalXZ, const float SPD, int nNextAIPattern )
{
	const float RESIST = getStaticData()->m_Setting.resist;
	// {
	lpAIInfo->startWalk( lpObject, lp3DInfo, vGoalXZ, SPD, RESIST,
		nNextAIPattern );
	// Xs[h
/*	const float SPD = 0.5f + RESIST;
	HPLVector vVelXZ = vGoalXZ;
	vVelXZ.setLength( SPD );

	HPL3DInfo::setVelocityAngleXZ( 
		lpHeroine, &lpHeroine->m_3DInfo, vVelXZ );
	lpHeroine->m_AIInfo.setAIPattern( nNextAIPattern );
	*/
	switch( lpObject->getObjectType()) {
	case ObjectType::PLAYER:
		{
			GEnko* lpEnko = (GEnko*)lpObject;
			lpEnko->changeState( StateType::WALK );
		}
		break;
	default:
		ASSERT_IT_TYPE( lpObject->getObjectType(), "ObjectType");
	}
	lpObject->setVelocity( SPD );
	// 
	lpObject->setFaceDirection(
		lpObject->m_vVelocityAngle.getX() > 0 ? FaceDirection::RIGHT : FaceDirection::LEFT );
}
