#include "GRoomScene.h"
#include "GStaticData.h"
#include "GEnkoManager.h"
#include <hpllib/general/HPLString.h>
#include <hpllib/action/HPL3DActionMoveTool.h>

//#include "GSceneCommonProc.h"
using namespace std;
GRoomScene::GRoomScene() {
}
void GRoomScene::init() {
	// test
	getStaticData()->setupMap( MapIndex::P_ROOM, true );

	int nEventBit = getStaticData()->m_Save.m_EnkoParameters.m_Counters.get( EnkoCounterType::EVENT_BIT );
	if( ! HPLMath::getFlagByIndexInt( nEventBit, EventBitType::FIRST )){
	//{
		// ŏ̃CxgsĂȂ
		// ŏ̃CxgX^[g
		getStaticData()->m_EventManager.start( EventType::FIRST_ROOM, true );
		// tO𗧂Ă
		nEventBit = HPLMath::setFlagByIndexInt( nEventBit, EventBitType::FIRST, true );
		getStaticData()->m_Save.m_EnkoParameters.m_Counters.set( EnkoCounterType::EVENT_BIT, nEventBit );
	}
}
void GRoomScene::quit() {
	getStaticData()->m_Game.setTheWorld( false );
}
void GRoomScene::process() {

	// wiF

	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();

	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();

	// scroll adjust

	// draw tiles
	getStaticData()->getBlockManager()->draw(getStaticData()->m_Basic.m_Graphics,
		getStaticData()->getScrollManager()->getScroller(0));

	const int TILE_SIZE = getStaticData()->m_Setting.tileSize;
	// search box
//	getStaticData()->m_EventManager.searchEventBox( lpEnko->m_vCenter, TILE_SIZE );

	// draw objects
	getStaticData()->m_ObjectManager.draw();

	// ړH
	bool bIsMove = getStaticData()->m_Game.isTheWorld() == false &&
		getStaticData()->m_Game.isMenu() == false;
	// łH
	bool bIsAI = bIsMove && getStaticData()->m_Game.isScenario() == false;

	// key update
	lpCursor->updateKeyState( true,
		getStaticData()->getInputManager(),
		KeyMap::MAX_KEY);

	const float RESIST = getStaticData()->m_Setting.resist;
	const float GRAVITY = getStaticData()->m_Setting.gravity;

	// update enko
	if( bIsMove ) {
		
		GEnkoManager enkoManager;
		
		if( bIsAI ) {
			if( lpEnko->isAlive()) {
				enkoManager.doAI( lpEnko );
			}
		}
		// check collision
		enkoManager.collisionCheck( lpEnko );

		///// commonȈړg
		HPL3DActionMoveTool::common3DMove( 
				lpEnko, &lpEnko->m_3DInfo,
				true, RESIST, GRAVITY );
		// move
		enkoManager.move( lpEnko );

	}


	// update objects
	// decals
	lpEnko->m_DecalManager.process( bIsMove, bIsAI );
	getStaticData()->m_ObjectManager.m_EnemyManager.process( bIsMove, bIsAI );
	getStaticData()->m_ObjectManager.m_NeutralManager.process( bIsMove, bIsAI );
	getStaticData()->m_ObjectManager.m_ItemManager.process( bIsMove, bIsAI );
//	getStaticData()->m_ObjectManager.m_ShotManager.process( bIsMove, bIsAI );
	getStaticData()->m_ObjectManager.m_EffectManager.process( bIsMove, bIsAI );
	getStaticData()->m_ObjectManager.m_AchievementManager.process( bIsMove, bIsAI );

	if( getStaticData()->m_Game.getHour() >= 22 ||
		getStaticData()->m_Game.getHour() < 5)
	{
		const int COORD_W = 15;
		const int COORD_H = 10;
		const int ALPHA = 80;
		// ȂÂ
		SetDrawBlendMode( DX_BLENDMODE_ALPHA, ALPHA );
		DrawBox(0,0,COORD_W * TILE_SIZE, COORD_H * TILE_SIZE, 
			GetColor(10,10,80 ), TRUE);
		SetDrawBlendMode( DX_BLENDMODE_NOBLEND, 255 );
	}
	// draw UI
	getStaticData()->m_GUI.drawPalette();

	// Cxg
	if( getStaticData()->m_EventManager.isEventMode() ) {
		getStaticData()->m_EventManager.doEventPack();
	}
	// draw cursor
	if( lpCursor->m_GrabInfo.isEnable() && lpCursor->m_GrabInfo.getObjectType() == ObjectType::PLAYER ) {
		// draw player
//		lpEnko->draw();
	}
}

