#include "GSave.h"

#include "GStaticData.h"
#include <iostream>
#include <fstream>
using namespace std;

#include <hpllib/general/HPLString.h>
#include <hpllib/system/HPLFile.h>
static const char SAVE_FILE_PATH[] = "user.sav";

void GEnkoParameters::resetParameters( int nResetType) {
	map<int,int> mapParams;
	// Œp[^
	mapParams[ ParameterType::HOPE] = PARAMETER_MAX / 2;
	mapParams[ ParameterType::PLEASURE] = 0;
	mapParams[ ParameterType::SAN] = PARAMETER_MAX;
	mapParams[ ParameterType::VITAL] = PARAMETER_MAX;
	mapParams[ ParameterType::LIFE_VITAL] = PARAMETER_MAX;
	mapParams[ ParameterType::FATIGUE] = 0;
	mapParams[ ParameterType::FOOD] = PARAMETER_MAX;
	mapParams[ ParameterType::NYO] = 0;
	mapParams[ ParameterType::E] = 0;
	mapParams[ ParameterType::INJURED] = 0;
	mapParams[ ParameterType::ILLNESS] = 0;

	switch( nResetType ) {
	case ResetType::FIRST:
		mapParams[ ParameterType::ANGER] = FIRST_ANGER;
		mapParams[ ParameterType::SAD] = FIRST_SAD;
		mapParams[ ParameterType::FEAR] = FIRST_FEAR;
		mapParams[ ParameterType::SLAVE] = FIRST_SLAVE;
		break;
	case ResetType::CLEARED:
		mapParams[ ParameterType::ANGER] = CLEAR_ANGER;
		mapParams[ ParameterType::SAD] = CLEAR_SAD;
		mapParams[ ParameterType::FEAR] = CLEAR_FEAR;
		mapParams[ ParameterType::SLAVE] = CLEAR_SLAVE;
		break;
	}
	for( map<int,int>::iterator it = mapParams.begin();
		it != mapParams.end();
		it ++ )
	{
		this->m_Parameters.set( it->first, it->second );
	}
}
void GEnkoParameters::resetCounters( int nResetType) {
	this->m_Counters.fill( 0 );
//	map<int,int> mapCounters;
}

void GEnkoParameters::resetUnderware( int nResetType ) {
	this->m_Underware.fill(0);
	this->m_Underware.set( ClothPartType::TOP, 1 );
	this->m_Underware.set( ClothPartType::UNDER, 1 );
}
/** Un
  */
void GEnkoParameters::commonAttack( int nAdd, vector<pair<int,int> >& vecParamDeltas ) {//HPLArrayContainer<int>* lpParameters ) {

	vecParamDeltas.push_back( pair<int,int>( ParameterType::VITAL, nAdd ) );
	vecParamDeltas.push_back( pair<int,int>( ParameterType::HOPE, nAdd ) );
	vecParamDeltas.push_back( pair<int,int>( ParameterType::ANGER, -nAdd ) );
	vecParamDeltas.push_back( pair<int,int>( ParameterType::PLEASURE, nAdd ) );
	vecParamDeltas.push_back( pair<int,int>( ParameterType::FEAR, -nAdd ) );
	if( this->m_Parameters.get( ParameterType::VITAL ) < VITAL_INJURED_THRESHOLD ) {
		vecParamDeltas.push_back( pair<int,int>(ParameterType::INJURED, -nAdd));
	}
	if( this->m_Parameters.get( ParameterType::VITAL ) <= 0 ) {
		// m
		vecParamDeltas.push_back( pair<int,int>(ParameterType::LIFE_VITAL, -5));
	}
}

/** J[\NbN
  */
void GEnkoParameters::action( GCursor* lpCursor, bool bIsUnder ) {
	// prev
/*	int aryOldParams[ ParameterType::MAX_NUM];
	for( int i = 0; i < ParameterType::MAX_NUM; i ++ ) {
		aryOldParams[i] = this->m_Parameters.get(i);
	}
	*/
	// ω̂̂
	vector<pair<int,int> > vecParamDeltas;

	switch( lpCursor->getType()) {
	case CursorType::PICK:
		commonAttack( -1, vecParamDeltas );
		break;
	case CursorType::GRAB:
		break;
	case CursorType::GIVE:
	case CursorType::PETTING:
	case CursorType::MIND_CONTROLLER:
	case CursorType::CLOTH_T:
	case CursorType::CLOTH_U:
	case CursorType::CHISEL:
		break;
	case CursorType::NUKOSU:
	case CursorType::ROTER:
	case CursorType::ROPE:
	case CursorType::LEG_BAR:
	case CursorType::EYE_BAND:
	case CursorType::PEN:
		break;
	case CursorType::BEAT:
	case CursorType::FLAME_THROWER:
	case CursorType::KNIFE:
	case CursorType::FOOT:
	case CursorType::SHOT:
		commonAttack( -5, vecParamDeltas );
		break;
	}

	// p[^ϓ{Oo
	this->changeParams( vecParamDeltas, true );
}

/** Q[Oɏo͂
  * p[^`FW
  * @param[in]	bIsAddGameLog	GameLogɃOo
  */
void GEnkoParameters::changeParams( vector<pair<int,int> >& vecParamDeltas, bool bIsAddGameLog ) {
	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();

	vector<string>* lpvecNames = lpCursor->m_NameSet.getNameContainer( lpCursor->getType());
	// Oɏo
	string str = HPLString::chrToStr( "[%s]", lpvecNames->at(0).c_str());

	if( lpvecNames->size() >= 2){

		int nAt = NameIndex::ACTION;
		switch( lpCursor->getType()) {
		case CursorType::CLOTH_T:
			if( this->m_Underware.get( ClothPartType::TOP ) == 0 ) {
				nAt = NameIndex::ACTION_2;
			}
			break;
		case CursorType::CLOTH_U:
			if( this->m_Underware.get( ClothPartType::UNDER ) == 0 ) {
				nAt = NameIndex::ACTION_2;
			}
			break;
		case CursorType::NUKOSU:
			if( this->m_Underware.get( ClothPartType::UNDER ) == 0 ) {
				nAt = NameIndex::ACTION_2;
			}
			break;
		}
#ifdef _DEBUG
		ASSERT_IT_INDEX( nAt, 0, lpvecNames->size());
#endif
		str += HPLString::chrToStr( "[%s]", lpvecNames->at(nAt ).c_str() );
	} else {
#ifdef _DEBUG
		HPLError::assertIt( false, "");
#endif
	}
	
	// ύXf

	const int MAX_NUM = vecParamDeltas.size();
	str = "";

	if( MAX_NUM > 0 ) {
		if( bIsAddGameLog ) {
			str += "(";
		}
		for( int i = 0; i < MAX_NUM; i ++ ) {
			int nDelta = vecParamDeltas[i].second;
			if( nDelta != 0 ) {
				int nParamType = vecParamDeltas[i].first;

				this->m_Parameters.add( nParamType, nDelta );
				// ϓGtFNg
				getStaticData()->m_GUI.m_aryParameterEffects[i].startDelta(nDelta );

				if( bIsAddGameLog ) {
					// Op
					str += HPLString::chrToStr( "%s%+d", PARAM_LABELS_JPN[nParamType],
						nDelta );
					if( i < MAX_NUM - 1 ) {
						str += ",";
					}
				}
			}
		}
		if( bIsAddGameLog ) {
			str += ")";
		}
	}
	
	if( bIsAddGameLog ) {
		getStaticData()->m_GUI.m_GameLogger.addDrawLine( str );
	}
}
/** ωʃXg擾
  */
void GEnkoParameters::getIntervalEffectParamDeltas( int nIntervalDetaType, vector<pair<int, int> >& vecParamDeltas ) {
	vecParamDeltas.clear();
	
	switch( nIntervalDetaType ) {
	case GIntervalEffectType::ROTER:
	case GIntervalEffectType::E:
	case GIntervalEffectType::CUM:
	case GIntervalEffectType::L_JUICE:
	case GIntervalEffectType::PEE:
		vecParamDeltas.push_back( pair<int,int>(ParameterType::E, 2));
		break;
	}
}

GSave::GSave(){
	this->setAsDefault();
}

static const char SAVE_FAILED_MSG[] = "Z[ut@Cۑł܂BANZXȂǂmFĂBe͕ۑ܂B";

void GSave::setAsDefault(){
	this->m_EnkoParameters.reset( ResetType::FIRST);
	this->m_ResearcherData.resetFirst();

}

static const char RESEARCHER_LABELS[][64] = {
	"MONEY",
	"NEUTRALS",
	"ELAPSE_DAYS",
	"RIPS",
	"MAPS",
	"ITEMS",
	"CURSORS",
	"ITEM_NUMS",
	"ENEMIES",
};

bool GSave::load() {
	vector<string> vecLines;
	try {
		vecLines = HPLFile::loadStringFromFile( 
			SAVE_FILE_PATH, true );
	} catch (... ) {
		HPLError::msg( "warning", MB_OK, "Z[ut@C܂B쐬܂");
		// error

		// ftHg
		this->setAsDefault();
		if( ! this->save() ) {
			// Z[us
		}
		return true;
	}

	try {
		const int MAX_LINES = vecLines.size();
		//! Ή
		//! ResearcherDataType -> TypeStateIndex
/*		map<int, int> mapTypes;
		mapTypes[ ResearcherDataType::MAPS] = GTypeStateIndex::MAPS;
		mapTypes[ ResearcherDataType::ITEMS] = GTypeStateIndex::ITEMS;
		mapTypes[ ResearcherDataType::NEUTRALS] = GTypeStateIndex::ITEMS;
		mapTypes[ ResearcherDataType::CURSORS] = GTypeStateIndex::CURSORS;
		mapTypes[ ResearcherDataType::ENEMIES] = GTypeStateIndex::ENEMIES;
		*/
		
		for( int i = 0; i < MAX_LINES; i ++ ) {
			vector<string> vecKeyValue = HPLString::split( vecLines[i], "=");
			
			// enko parameters
			bool bIsValid = false;
			int nType = -1;
			for( int j = 0; j < ParameterType::MAX_NUM; j ++ ) {
				if( HPLString::equals( vecKeyValue[0], PARAM_LABELS[j] ) ) {
					nType = j;
					bIsValid = true;
					break;
				}
			}

			if( bIsValid ) {
				int nValue = atoi( vecKeyValue[1].c_str());
				this->m_EnkoParameters.m_Parameters.set( nType, nValue );
				continue;
			}

			// bIsValid == false

			// enko counters
			for( int j = 0; j < EnkoCounterType::MAX_NUM; j ++ ) {
				if( HPLString::equals( vecKeyValue[0], COUNTER_LABELS[j] ) ){
					nType = j;
					bIsValid = true;
					break;
				}
			}

			if( bIsValid ) {
				int nValue = atoi( vecKeyValue[1].c_str());
				this->m_EnkoParameters.m_Counters.set( nType, nValue );
				continue;
			}

			// bIsValid == false

			// researcher datas
			nType = -1;
			const int MAX_LABELS = SIZEOF( RESEARCHER_LABELS );
			for( int j = 0; j < MAX_LABELS; j ++ ) {
				if( HPLString::equals( vecKeyValue[0], RESEARCHER_LABELS[j] ) ) {
					nType = j;
					bIsValid = true;
					break;
				}
			}
			if( bIsValid ) {
				switch( nType ) {
				case ResearcherDataType::MONEY:
					{
						long lValue = atol( vecKeyValue[1].c_str());
						this->m_ResearcherData.setMoney( lValue );
					}
					break;
				case ResearcherDataType::ELAPSE_DAYS:
					{
						long lValue = atol( vecKeyValue[1].c_str());
						this->m_ResearcherData.setElapseDays( lValue );
					}
					break;
				case ResearcherDataType::RIPS:
					{
						long lValue = atol( vecKeyValue[1].c_str());
						this->m_ResearcherData.setRips( lValue );
					}
					break;
				case ResearcherDataType::MAPS:
				case ResearcherDataType::NEUTRALS:
				case ResearcherDataType::ITEMS:
				case ResearcherDataType::CURSORS:
				case ResearcherDataType::ENEMIES:
					{
						int nTypeStateIndex = getTypeStateIndexFromResearcherDataType( nType );
						vector<string> vecItems = HPLString::split( vecKeyValue[1], "," );
						for( int i = 0; i < MapIndex::MAX_NUM && i < vecItems.size(); i ++ ) {
							this->m_ResearcherData.setTypeState( 
								nTypeStateIndex, i, 
								atoi( vecItems[i].c_str() ));
						}
					}
					break;
				case ResearcherDataType::ITEM_NUMS:
					{
						vector<string> vecItems = HPLString::split( vecKeyValue[1], "," );
						const int MAX_NUM = vecItems.size();
						for( int i = 0; i < MAX_NUM && i < Sequence::Item::MAX_NUM; i ++ ) {
							this->m_ResearcherData.setItemNum( 
								i, atoi( vecItems[i].c_str() ) );
						}
					}
					break;
				default:
#ifdef _DEBUG
					ASSERT_IT_TYPE( nType, "Researcher Daya Type");
#endif
					;
				}
				continue;
			} // is valid

			// underware
			nType = -1;
			for( int j = 0; j < ClothPartType::MAX_NUM; j ++ ) {
				if( HPLString::equals( vecKeyValue[0], CLOTH_PART_LABELS[j] ) ) {
					nType = j;
					bIsValid = true;
					break;
				}
			}
			if( bIsValid && nType >= 0 ) {

				this->m_EnkoParameters.m_Underware.set( nType, atoi( vecKeyValue[1].c_str()));
			}
#ifdef _DEBUG
			HPLError::assertIt( bIsValid,
				"Unknown nType[%s,%d]", vecKeyValue[0].c_str(), nType);
#else
			if( ! bIsValid ) {
				continue;
			}
#endif
		}
	} catch( ... ) {
		switch( HPLError::msg( "error", MB_YESNO, "Z[uf[^̓ǂݍ݂Ɏs܂BZ[ut@CĂA܂͉ĉ\܂B܂H(ȂꍇAvP[VI܂)") ) {
		case IDYES:
			this->setAsDefault();
			if( ! this->save() ) {
				// Z[us
			}
			return true;
		default:
			HPLError::msg( "message", MB_OK, "AvP[VI܂B");
			exit(-1);
		}
	}
	if( ! this->m_ResearcherData.m_NeutralData.load() ) {
		return false;
	}
	return true;
}
bool GSave::save() {
	ofstream ofs( SAVE_FILE_PATH );
	if( ! ofs.is_open()) {
		// save s
		HPLError::msg( "error", MB_OK, SAVE_FAILED_MSG);
		return false;
	}

	// save parameters
	for( int i = 0; i < ParameterType::MAX_NUM; i ++ ) {
		string str = HPLString::chrToStr( "%s=%d\n", PARAM_LABELS[i], this->m_EnkoParameters.m_Parameters.get(i));
		ofs.write( str.c_str(), str.length());
	}

	// save counters
	for( int i = 0; i < EnkoCounterType::MAX_NUM; i ++ ) {
		string str = HPLString::chrToStr( "%s=%d\n", COUNTER_LABELS[i], this->m_EnkoParameters.m_Counters.get(i));
		ofs.write( str.c_str(), str.length());
	}


	// save researcher data
	// money
	string str = HPLString::chrToStr( "%s=%ld\n",
		RESEARCHER_LABELS[ResearcherDataType::MONEY],
		this->m_ResearcherData.getMoney());
	ofs.write( str.c_str(), str.length());

	// neutrals
/*	string strList;
	for( int i = 0; i < Sequence::Neutral::MAX_NUM; i ++ ) {
		strList += HPLString::chrToStr( "%d",
			this->m_ResearcherData.isNeutral(i) ? 1 : 0 );
		if( i < Sequence::Neutral::MAX_NUM - 1 ) {
			strList += string( ",");
		}
	}
	str = HPLString::chrToStr( "%s=%s",
		RESEARCHER_LABELS[ResearcherDataType::NEUTRALS],
		strList.c_str());
	ofs.write( str.c_str(), str.length());
*/
	// elapse
	str = HPLString::chrToStr( "%s=%ld\n",
		RESEARCHER_LABELS[ResearcherDataType::ELAPSE_DAYS],
		this->m_ResearcherData.getElapseDays());
	ofs.write( str.c_str(), str.length());

	// rips
	str = HPLString::chrToStr( "%s=%ld\n",
		RESEARCHER_LABELS[ResearcherDataType::RIPS],
		this->m_ResearcherData.getRips());
	ofs.write( str.c_str(), str.length());

	{
		int TYPES[][2] = {
			{ ResearcherDataType::MAPS, GTypeStateIndex::MAPS },
			{ ResearcherDataType::ITEMS, GTypeStateIndex::ITEMS },
			{ ResearcherDataType::NEUTRALS, GTypeStateIndex::NEUTRALS },
			{ ResearcherDataType::CURSORS, GTypeStateIndex::CURSORS },
			{ ResearcherDataType::ENEMIES, GTypeStateIndex::ENEMIES },
		};
		const int MAX_NUM = SIZEOF( TYPES );
		for( int i = 0; i < MAX_NUM; i ++ ) {
			// max num
			const int ITEMS_MAX_NUM = this->m_ResearcherData.m_vecTypeStates[i].size();
			// maps
			str = HPLString::chrToStr( "%s=%s\n",
				RESEARCHER_LABELS[ TYPES[i][0] ],
				HPLString::getListStringFromArray( &
					this->m_ResearcherData.m_vecTypeStates[TYPES[i][1]]).c_str());
			ofs.write( str.c_str(), str.length());
		}
	}

	str = HPLString::chrToStr( "%s=%s\n",
		RESEARCHER_LABELS[ ResearcherDataType::ITEM_NUMS],
		HPLString::getListStringFromArray(
		Sequence::Item::MAX_NUM, this->m_ResearcherData.m_aryItemNums ).c_str());
	ofs.write( str.c_str(), str.length());

	ofs.close();

	if( ! this->m_ResearcherData.m_NeutralData.save()) {
		return false;
	}
	// ۑ
	getStaticData()->m_GUI.m_GameLogger.addDrawLine( string("Z[u܂"));
	return true;
}
