#include "GShotManager.h"

#include "GStaticData.h"
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPLShootingMove.h>
#include <hpllib/game/HPLChaseInfo.h>
#include <hpllib/action/HPLObjectCollisionCheckTool.h>

GShotManager::GShotManager() {
	// load
//	GShotSetting::load( "data\\image\\shot\\ShotSettings.txt", this->m_vecShotSettings );
}

void GShotManager::process(bool bIsMove, bool bIsAI) {
	HPLRect rGameRange = getStaticData()->getGameRange();

	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();

	const float BOUNCE_REMAIN_RATE_X = 1;
	const float BOUNCE_REMAIN_RATE_Y = BOUNCE_REMAIN_RATE_X;
	for( list<GShot*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		)
	{
		GShot* lpShot = *it;
		if( ! rGameRange.isShare( lpShot->getHitArea()) ) {
			lpShot->setAlive( false );
		}
		if( lpShot->isAlive() ) {
			// move
			if( bIsMove ) {
				const float RESIST = getStaticData()->m_Setting.resist;
				const float GRAVITY = getStaticData()->m_Setting.gravity;
				// move
				HPL3DActionMoveTool::common3DMove( 
					lpShot, & lpShot->m_3DInfo,
					true, RESIST, GRAVITY );
				if( bIsAI ) {
					this->algorithm( lpShot );
				}
				// hit to enemy
//				this->checkHitPlayer( lpShot, lpPlayer );
//				this->checkHitToEnemy( lpShot );
//				this->checkHitToNeutral( lpShot );

				// check collision
				CollisionState stResultX, stResultY;
				// collision
				bool bIsHit = getStaticData()->m_CollisionCheckTool.commonCollisionObject3D(
					lpShot, &lpShot->m_3DInfo, Z_THRESHOLD, stResultX, stResultY,
					BOUNCE_REMAIN_RATE_X, BOUNCE_REMAIN_RATE_Y,
					HitArea3DType::LAID);
				if( bIsHit && lpShot->getObjectAttribute( ObjectAttribute::HIT_TO_BLOCK ) &&	// Ԃ
					lpShot->getObjectAttribute( ObjectAttribute::HIT_BLOCK_TO_DIE ) )	// ubNŎʃ^Cv
				{
					// die
					lpShot->die(NULL);
					// hit effect
//					this->createHitEffect( lpShot, lpShot );
				}
			}
		}
		if( lpShot->isAlive()) {
			lpShot->draw();
			it ++;
		} else {
			delete lpShot;
			it = this->getList()->erase( it );
		}
	}
	// add reserve
	for( list<GShot*>::iterator it = this->getReserves()->begin();
		it != this->getReserves()->end();
		it ++
		)
	{
		GShot* lpShot = *it;
		this->getList()->push_back( lpShot );
	}
	this->clearReserves();
}
GShot* GShotManager::create(int nShotType, HPLVector vCenterXY, int nParentID,
							int nFaceDirection, 
							int nAddType)
{
	GShot* lpShot = new GShot( nShotType );

	lpShot->setCenter( vCenterXY );
	lpShot->m_3DInfo.setZ( vCenterXY.getY());
	lpShot->setParentID( nParentID );
	lpShot->setFaceDirection( nFaceDirection );
//	lpShot->setFaceDirection3D( nFaceDirection3D );
	switch( nAddType ) {
	case HPL::AddType::RESERVE:
		this->getReserves()->push_back( lpShot );
		break;
	case HPL::AddType::LIST:
		this->getList()->push_back( lpShot );
		break;
	default:
		ASSERT_IT_TYPE( nAddType, "AddType");
	}
	return lpShot;
}
/** ʏ
  */
void GShotManager::algorithm(GShot* lpShot) {
}
