#include "GStaticData.h"

#include <hpllib/general/HPLPointerTool.h>
#include <hpllib/system/HPLFile.h>
#include <hpllib/system/HPLLogger.h>
#include <hpllib/general/HPLString.h>
#include <hpllib/action/HPL3DActionMoveTool.h>

//#include "GSplashscene.h"
#include "GTitleScene.h"
#include "GRoomScene.h"
#include "GEventScene.h"
//#include "GClearScene.h"
//#include "GGalleryScene.h"
//#include "GLabScene.h"


GStaticData staticData;
GStaticData* getStaticData() {
	return &staticData;
}

GStaticData::GStaticData() : AbstractDXStaticData () {
	HPLMath::setupTables( );
	const int FADE_OUT_WAIT_FRAME = 20;
	this->m_FadeOutCounter.setWaitFrameNum( FADE_OUT_WAIT_FRAME );
	const int TILE_SIZE = this->getSetting()->tileSize;
	this->getBlockManager()->setBlockSize( TILE_SIZE );
	HPLRect rWindowRect = HPLRect( 0,0,this->m_Setting.windowWidth, this->m_Setting.windowHeight );
	HPLScroller* lpScroller = this->m_ScrollManager.getScroller(0);
	lpScroller->setScreenRect( 0,0,15 * TILE_SIZE, 9 * TILE_SIZE );
	this->m_Save.load();

	this->m_EventManager.setup( 
		&this->m_EventBoxManager, &this->m_EventPackManager );
}

GStaticData::~GStaticData() {
}
/** eNX`/C[Wǂݍ݁ZbgAbv
  */
void GStaticData::loadTexture() {


	// load images
	this->m_Basic.m_Graphics.m_SpriteContainer.createImageSetContainer( "data\\image\\ImageSetFileList.dat" );
	this->m_SceneManager.putScene( SceneType::TITLE,
		new GTitleScene() );
	this->m_SceneManager.putScene( SceneType::ROOM,
		new GRoomScene() );
	this->m_SceneManager.putScene( SceneType::EVENT,
		new GEventScene() );
	// tile image
	HPLSprite* lpSprite = this->getSprite( SpriteType::COMMON );
	int nHandle = this->getImageHandle( SpriteType::COMMON, Sequence::Common::TILE );
	
	// setup block info and tile images
	this->getBlockManager()->setupBlock("data\\maps\\Block000.txt",
		lpSprite->clone(), nHandle );

	this->m_CollisionCheckTool.setup( this->getBlockManager(),
		this->m_Setting.tileSize );
	// object manager setup
	this->m_ObjectManager.setup();

	// se load
	vector<string> vecLines = HPLFile::loadStringFromFile( "data\\se\\SE.txt", true);
	for( int i = 0; i < (int)vecLines.size(); i ++ ) {
		string strPath = string("data\\se\\") + vecLines[i];
		// load
		int nHandle = this->m_MixerManager.add( strPath.c_str());
		// ʒ΁AnHandlegp
	}
	// music load
	vecLines = HPLFile::loadStringFromFile( "data\\music\\Music.txt", true);
	for( int i = 0; i < (int)vecLines.size(); i ++ ) {
		string strPath = string("data\\music\\") + vecLines[i];
		int nHandle = this->m_MixerManager.addMusic( strPath.c_str());
		// (ry
	}

}
void GStaticData::drawFadeOutDX() {

	const int ALPHA = (int)( 255.f * this->m_FadeOutCounter.getStepCounterRate());
	if( ALPHA == 0 ) {
		return;
	}
	// Ƃ肠`hԂ
	SetDrawBlendMode( DX_BLENDMODE_ALPHA, ALPHA);
	DrawBox( 0,0, this->m_Setting.windowWidth, this->m_Setting.windowHeight,
		GetColor(1,1,1), TRUE);
	SetDrawBlendMode( DX_BLENDMODE_NOBLEND , 255);
}

void GStaticData::setupMap(int nMapIndex, bool bIsLoadEvent ) {
	// vtBbNX擾(*.emp"*")
	// łɃJg}bvCfbNXo^
	string strMapFilePathPrefix = this->m_MapManager.getMapFilePath(nMapIndex);

	// empt@C
	string strEMP = strMapFilePathPrefix + string( ".emp");

	// { csv
	string strMapCSVFilePath = strMapFilePathPrefix + std::string(".csv");
	// IuWFNgzu
	// zupf[^t@CpX
	string strObjectPlaceCSVFilePath = strMapFilePathPrefix + std::string("-object.csv");

	// Cxg{bNX񂪖ꍇ̃ftHgf[^
	string strEventBoxPath("data\\maps\\NULL_EventBox.txt");

	// Cxg{bNX()
	string strEventBoxFilePath = strMapFilePathPrefix + std::string(".txt");
	if( HPLFile::isExists(strEventBoxFilePath.c_str()) == true){
		strEventBoxPath = strEventBoxFilePath;
	}

	if( HPLFile::isExists( strEMP.c_str()) ) {
		vector<string> vecLines = HPLFile::loadStringFromFile(
			strEMP.c_str(), true );
		for( int i = 0; i < (int)vecLines.size(); i ++ ) {
			string strLine = vecLines[i];
			vector<string> vecEquals = HPLString::split( strLine, "=");

			if( vecEquals.size() < 2 ) {
				LOG_WARN( HPLString::chrToStr("Invalid emp file[%s]:%s",
					strEMP.c_str(), strLine.c_str()).c_str());
				continue;
			}
			if( HPLString::equals( vecEquals[0], "PlayerStartIndex")) {
				int nIndex = atoi( vecEquals[1].c_str());

			} else if( HPLString::equals( vecEquals[0], "Size")){
				// TODO use
			} else if( HPLString::equals( vecEquals[0], "Terrain")) {
				string strPath = vecEquals[1];
				if( HPLFile::isExists( strPath.c_str())) {
					strMapCSVFilePath = strPath;
				}
			} else if( HPLString::equals( vecEquals[0], "Objects")) {
				string strPath = vecEquals[1];
				if( HPLFile::isExists( strPath.c_str()) ) {
					strObjectPlaceCSVFilePath = strPath;
				}
			} else{
				LOG_WARN( HPLString::chrToStr( "Unknown setting found[%s]:%s",
					strEMP.c_str(), strLine.c_str()).c_str());
				continue;
			}
		}
	} else {
		LOG_POINT( HPLString::chrToStr( "No emp file found. Loading by default name pattern.[%s]",
			strEMP.c_str()).c_str());
	}
	if( bIsLoadEvent ) {
		this->m_EventManager.loadEventPack( NULL );
		// load event boxes
		m_EventBoxManager.load(strEventBoxPath.c_str() );
	}

	// IuWFNgNA
	this->m_ObjectManager.clear();

	AbstractBlockManager* blockManager = this->getBlockManager();

	// }bv}gNX[h
	blockManager->loadMatrix(strMapCSVFilePath.c_str());

	// ^CTCY
	const int TILE_SIZE = this->getSetting()->tileSize;

	// setup scroll size
	HPLRect virRect(0,0,
		(float)(blockManager->getBlockMatrix()->getColumnSize() * TILE_SIZE),
		(float)(blockManager->getBlockMatrix()->getRowSize() * TILE_SIZE));

	HPLScroller* scroller = this->getScrollManager()->getScroller(0);
	scroller->setVirtualRect(virRect);

	// reset game param
	this->m_Game.setGameOver(false);
	this->m_Game.setMenu(false);
	this->m_Game.setScenario(false);
	this->m_Game.setTheWorld(false);

	// IuWFNgzupf[^
	AbstractBlockManager placerBlockManager;

	// IuWFNgzuǂݍ
	placerBlockManager.loadMatrix( strObjectPlaceCSVFilePath.c_str());

	// IuWFNgzu
	this->m_ObjectPlacer.loadAndPlace(placerBlockManager.getBlockMatrix(),
		this->m_Setting.tileSize,
		this->getMapData(),
		nMapIndex);

	// Xe[Wɍ킹āAKvȂ́iwς݂̂́j
	// zu?zu邩ǂ́AzuɍwǂŔf
	switch( nMapIndex ) {
	case MapIndex::P_ROOM:

		break;
	}
	GEnko* lpEnko = this->m_ObjectManager.getEnko();
	// Ԗ߂iz[hȂǂ̓[X
	lpEnko->rollBackState( true );
}
HPL3DInfo* GStaticData::get3DInfo( HPLShootingObject* lpObject ) {
	switch( lpObject->getObjectType()) {
	case ObjectType::PLAYER:
		return &((GEnko*)lpObject)->m_3DInfo;
	case ObjectType::NEUTRAL:
		return &((GNeutral*)lpObject)->m_3DInfo;
	case ObjectType::ENEMY:
		return &((GEnemy*)lpObject)->m_3DInfo;
	case ObjectType::ITEM:
		return &((GItem*)lpObject)->m_3DInfo;
	case ObjectType::EFFECT:
		return &((GEffect*)lpObject)->m_3DInfo;
	case ObjectType::SHOT:
		return &((GShot*)lpObject)->m_3DInfo;
	default:
		ASSERT_IT_TYPE( lpObject->getObjectType(), "Object Type");
	}
	return NULL;
}

void GStaticData::drawShadow( HPLShootingObject* lpObject ) {
	AbstractDXStaticData::drawShadow( lpObject,
		this->getSequence( SpriteType::COMMON, Sequence::Common::SHADOW),
		this->get3DInfo( lpObject ));
}

/** eMinZ([)Qbg

  */
int GStaticData::getMinZ( int nMapIndex ) {
	int nCoordY = 7;
	switch( nMapIndex ) {
	case MapIndex::MULTI_PURPOSE:
		nCoordY = 4;
		break;
	}

	const int TILE_SIZE = this->m_Setting.tileSize;
	// coord̏[
	return nCoordY * TILE_SIZE;
}
int GStaticData::getMaxZ( int nMapIndex ) {
	int nCoordY = 9;
	const int TILE_SIZE = this->m_Setting.tileSize;
	return nCoordY * TILE_SIZE;
}

