#pragma once
#include <HPLDXLib.h>
#include <AbstractDXStaticData.h>

#include "GEnum.h"
#include "GObjectManager.h"


#include "GGame.h"
#include "GSetting.h"
#include "DXMixerManager.h"
#include "GSave.h"
//#include "GSystemData.h"
#include "GEnko.h"

#include "GGUI.h"

//#include "GShotFactory.h"
//#include "GBGManager.h"
//#include "GImageItem.h"

#include "GEventManager.h"
//#include "GTalkManager.h"
//#include <hpllib/game/HPLShowCounter.h>
#include <hpllib/action/HPLCollisionCheckTool.h>
#include "GEventScene.h"
//#include "GClearScene.h"
#include "GObjectPlacer.h"
//#include "GTitleScene.h"

#include "GMoneyInfoManager.h"

/** Q[f[^Ǘ
  */
class GStaticData : public AbstractDXStaticData {
	// Member variables
public:
	GObjectManager		m_ObjectManager;			//! IuWFNgǗ
	GGame				m_Game;
	GSetting			m_Setting;
	GObjectPlacer		m_ObjectPlacer;
	DXMixerManager		m_MixerManager;

	GEventManager		m_EventManager;

	GSave m_Save;
	//! n`Ƃ̐ڐGA
	HPLCollisionCheckTool m_CollisionCheckTool;

	// GUI
	GGUI m_GUI;

	// money
	GMoneyInfoManager m_MoneyInfoManager;
private:

public:
public:
	GStaticData();
	virtual ~GStaticData();
public:// Override
	void callbackStageChange(){}
	virtual HPLSetting* getSetting() {	return &this->m_Setting;	}

	void setupMap(int nMapIndex , bool bIsEvent );

	void drawFadeOutDX();
	void drawShadow( HPLShootingObject* lpObject );
public:
	/** eNX`/C[Wǂݍ݁ZbgAbv
	  */
	void loadTexture();
	HPL3DInfo* get3DInfo( HPLShootingObject* obj );

	GEventScene* getEventScene() {
		return (GEventScene*)this->m_SceneManager.getScene( SceneType::EVENT );
	}

	/** eMinZ([)Qbg

	  */
	int getMinZ( int nMapIndex );
	int getMaxZ( int nMapIndex );
};

extern GStaticData staticData;

GStaticData* getStaticData();
