#pragma once

#include <tchar.h>

namespace Enum {
	namespace TileType {
		enum {
			EMPTY,
			BLOCK,
			SLOPE_L_HALF_A,
			SLOPE_L_HALF_B,
			SLOPE_R_HALF_A,
			SLOPE_R_HALF_B,
			SLOPE_L,
			SLOPE_R,
			EMPTY_DRAW_FRONT,
			MAX_NUM,
		};
	}
	static const TCHAR TILE_TYPE_LABELS[][32] = {
		_T("[EMPTY]"),
		_T("[BLOCK]"),
		_T("[SLOPE_L_HALF_A]"),
		_T("[SLOPE_L_HALF_B]"),
		_T("[SLOPE_R_HALF_A]"),
		_T("[SLOPE_R_HALF_B]"),
		_T("[SLOPE_L]"),
		_T("[SLOPE_R]"),
		_T("[EMPTY_DRAW_FRONT]"),
	};

	static const TCHAR CMD_NUMBER_OF_BLOCKS_PER_LINE[] = _T("NUMBER_OF_BLOCKS_PER_LINE");
	static const TCHAR CMD_ID[] = _T("ID");
}
