#ifndef USERCOEFH
#define USERCOEFH


#define BLURTIMEMAX	20
#define DISPSWITCHNUM	100
#define CAMERANUMMAX	3

#define MOELISTLENG	15
#define MAXEXTTEXNUM	100



typedef struct tag_texchange
{
	int materialno;
	char texname[256];
}TEXCHANGE;

typedef struct tag_dschange
{
	int switchno;
	int state;
}DSCHANGE;


typedef struct tag_idchange
{
	int befid;
	int newid;
} IDCHANGE;

typedef struct tag_eulerlimit
{
	int ignoreflag;
	D3DXVECTOR3 lim0;
	D3DXVECTOR3 lim1;
} EULERLIMIT;

typedef struct tag_e3dq
{
	float x;
	float y;
	float z;
	float w;
} E3DQ;

typedef struct tag_za4elem
{
	int zatype;
	int rotaxis;
	E3DQ za4q;
}ZA4ELEM;

enum {
	ZA_1,
	ZA_2,
	ZA_3,
	ZA_4,
	ZA_MAX
};

enum {
	ROTAXIS_X,
	ROTAXIS_Y,
	ROTAXIS_Z,
	ROTAXIS_MAX
};


typedef struct tag_MOEELEM
{
	int listnum;
	int list[MOELISTLENG];
	int notlistnum;
	int notlist[MOELISTLENG];
	int eventno;
}MOEELEM;

typedef struct tag_e3dgpstate
{
	D3DXVECTOR3 pos;
	D3DXVECTOR3 rot;
	int	ongmode;
	float	rayy;
	float	rayleng;
	float	offsety;
	int interp;
}E3DGPSTATE;

enum {//GP ongmode
	GROUND_NONE,
	GROUND_ONE,
	GROUND_ON,
	GROUND_MAX
};

enum {//CAMERA looktype̒l
	CAML_NORMAL,//LȂ
	CAML_LOOKONCE,//L[̏uԂ
	CAML_LOCK,//̃L[܂Œ
	CAML_MAX
};

typedef struct tag_e3dcamerastate
{
	int looktype;
	D3DXVECTOR3 pos;
	D3DXVECTOR3 target;
	D3DXVECTOR3 up;
	float dist;

	int hsid;
	int boneno;

	float nearz;
	float farz;
	float fov;
	int ortho;
	float orthosize;

	int interp;
}E3DCAMERASTATE;

enum {
	//hspp E3DGetMorphBaseInfo
	MBI_DISPNO,
	MBI_BONENO,
	MBI_TARGETNUM,
	MBI_MAX
};

typedef struct tag_e3dmorphbase
{
	char name[256];
	int dispno;
	int boneno;
	int targetnum;
}RDBMORPHBASE, E3DMORPHBASE;

typedef struct tag_e3dmorphtarget
{
	char name[256];
	int dispno;
}RDBMORPHTARGET, E3DMORPHTARGET;

typedef struct tag_e3dmorphmotion
{
	int frameno;
	float blendrate;
}RDBMORPHMOTION, E3DMORPHMOTION;


enum {
	BLUR_NONE,
	BLUR_WORLD,
	BLUR_CAMERA,
	BLUR_MAX
};

enum {
	GLOW_NONE,
	GLOW_NORMAL,
	GLOW_ALPHA,
	GLOW_MAX
};

typedef struct tag_e3dcolor4uc
{
	unsigned char a;
	unsigned char r;
	unsigned char g;
	unsigned char b;
} E3DCOLOR4UC;

typedef struct tag_e3dcolor3uc
{
	unsigned char r;
	unsigned char g;
	unsigned char b;
} E3DCOLOR3UC;


typedef struct tag_e3dcolor4f
{
	float r;
	float g;
	float b;
	float a;
} E3DCOLOR4F;

typedef struct RDBColor3f
{
public:
	float r;
	float g;
	float b;
} RDBColor3f;

typedef struct tag_e3dtoon1material
{
	char name[32];

	RDBColor3f diffuse;
	RDBColor3f ambient;
	RDBColor3f specular;

	float darknl;//@ƃCg̓ς臒l
	float brightnl;

	RDBColor3f edgecol0;
	int edgevalid0;
	int edgeinv0;
	float edgewidth0;
	
}E3DTOON1MATERIAL;


typedef struct tag_bbinfo
{
	int bbid;
	D3DXVECTOR3 pos;
	char texname[256];
	int transparent;
	float width;
	float height;
} BBINFO;


enum {
	MPI2_MPID,
	MPI2_QUA,
	MPI2_TRA,
	MPI2_FRAMENO,
	MPI2_INTERP,
	MPI2_SCALE,
	MPI2_USERINT1,
	MPI2_MAX
};
typedef struct tag_MPINFO2
{
	int mpid;
	int qid;
	D3DXVECTOR3 tra;
	int frameno;
	int interpolation;
	D3DXVECTOR3 scale;
	int userint1;
} MPINFO2;


typedef struct tag_jointinfo
{
	char name[256];
	int serialno;
	int notuse;
	int parent;
	int child;
	int brother;
	int sister;
} JOINTINFO;


typedef struct tag_dispobjinfo
{
	char name[256];
	int serialno;
	int notuse;
	int dispswitch;
	int invisible;
} DISPOBJINFO;

typedef struct tag_fullscreenparams
{
	int validflag;
	int bits;
	SIZE scsize;
} FULLSCPARAMS;

typedef struct tag_trivno
{
	int vert1;
	int vert2;
	int vert3;
} TRIVNO;

typedef struct tag_bsphere
{
	D3DXVECTOR3 center;
	float r;
} BSPHERE;

typedef struct tag_uv
{
	float u;
	float v;
} UV;

typedef struct tag_textureinfo
{
	int texid;
	int width;
	int height;
	int pool;
	int format;
	int transparent;
	char name[256];//gp
} TEXTUREINFO;

//ShaderType
enum {
	COL_OLD,
	COL_PHONG,
	COL_BLINN,
	COL_SCHLICK,
	COL_MQCLASSIC,
	COL_TOON0,
	COL_TOON1,
	COL_PPHONG,
	COL_MAX
};

enum tag_calcmode
{
	CALCMODE_NOSKIN0,//XLjOȂ
	CALCMODE_ONESKIN0,//ƓςvZ
	CALCMODE_ONESKIN1,//vZ
	CALCMODE_DIRECT0,//l̒ڎw
	CALCMODE_SYM,//Ώ̐ݒ
	CALCMODE_MAX
};

//E3DSetInfElem
enum {
	PAINT_NOR,//m[}
	PAINT_EXC,//r
	PAINT_ADD,//Z
	PAINT_SUB,//Z
	PAINT_ERA,//
	PAINT_MAX
};

typedef struct tag_e3dinfelem
{
	int infno;
	int childjointno;//e{[Aq̔ԍBGhWCgB
	int calcmode;//CALCMODE_*
	float userrate;//
	float orginf;//CALCMODE_*ŌvZlB
	float dispinf;//@orginf[] * userrate[]AnormalizeflagP̂Ƃ́AKB
} E3DINFELEM;

typedef struct tag_toon0params
{
	float darkrate;
	float brightrate;
	float darkdeg;
	float brightdeg;
} TOON0PARAMS;

typedef struct tag_moainfo
{
	char name[256];
	int id;
} MOAINFO;

typedef struct tag_moatrunkinfo
{
	int idling;
	int ev0idle;
	int comid;
	int notcomnum;
	int* notcomid;
	int branchnum;
} MOATRUNKINFO;

typedef struct tag_moabranchinfo
{
	int motid;
	int eventno;
	int frameno1;
	int frameno2;
	int notfu;
} MOABRANCHINFO;

enum {
	SHADOWIN_PROJ,		//ɈꕔłĂVhE}bvɓ
	SHADOWIN_ALWAYS,	//ɃVhE}bvɓ
	SHADOWIN_NOT,		//䂵ȂinʂȂǂ̑傫IuWFNgpj
	SHADOWIN_EXCLUDE	//VhE}bv珜OB
};

enum {
	BONETYPE_RDB2,
	BONETYPE_MIKO,
	BONETYPE_MAX
};

typedef struct tag_materialinfo
{
	int materialno;
	char name[256];
	float alpha;
	E3DCOLOR4UC diffuse;
	E3DCOLOR4UC specular;
	E3DCOLOR4UC ambient;
	E3DCOLOR4UC emissive;
	float power;
} MATERIALINFO;

typedef struct tag_toon1materialinfo
{
	char name[32];
	E3DCOLOR4UC ambient;
	E3DCOLOR4UC diffuse;
	E3DCOLOR4UC specular;
	int edgevalid;
	E3DCOLOR4UC edgecol0;
	float edgewidth;
} TOON1MATERIALINFO;


// E3DSetSymInfElemŎgp
enum {
	SYMAXIS_NONE,
	SYMAXIS_X,
	SYMAXIS_Y,
	SYMAXIS_Z,
	SYMAXIS_MAX
};

enum {
	QUATYPE_NUM,
	QUATYPE_NAME,
	QUATYPE_MAX
};

enum {
	TEXRULE_X,
	TEXRULE_Y,
	TEXRULE_Z,
	TEXRULE_CYLINDER, 
	TEXRULE_SPHERE,
	TEXRULE_MQ,
	TEXRULE_RAP,//
	TEXRULE_MAX
};

enum {
	EXTTEXMODE_NORMAL,
	EXTTEXMODE_ANIM,
	EXTTEXMODE_MULTI,//
	EXTTEXMODE_GLOW,
	EXTTEXMODE_GLOWALPHA,
	EXTTEXMODE_MAX
};

enum {
	TEXANIM_WRAP,
	TEXANIM_NOLIMIT,
	TEXANIM_MAX
};

typedef struct tag_materialtex
{
	char tex[256];
	char bump[256];
	
	int exttexnum;
	char exttex[MAXEXTTEXNUM][256];
	int exttexmode;//EXTTEXMODE_*

	int transparent;//0s,1,2eNX`At@
	float uanim;
	float vanim;
	int texrule;//TEXRULE_*
	int texanimtype;//TEXANIM_*

	RDBColor3f glowmult;	
}MATERIALTEX;

typedef struct tag_materialtex1dim
{
	char tex[256];
	char bump[256];
	
	int exttexnum;
	char exttex[256 * MAXEXTTEXNUM];
	int exttexmode;//EXTTEXMODE_*

	int transparent;//0s,1,2eNX`At@
	float uanim;
	float vanim;
	int texrule;//TEXRULE_*
	int texanimtype;//TEXANIM_*

	RDBColor3f glowmult;	
}MATERIALTEX1DIM;

#endif

