#ifndef _ABSTRACT_OBJECT_MANAGER_
#define _ABSTRACT_OBJECT_MANAGER_

#include <list>
#include <map>
#include <exception>

#include <windows.h>

#include "E3DCloneManager.h"

#include "E3DObject.h"

namespace HPL {
namespace E3D {
/** IuWFNg̈A̗ǗNX
  *
  */
template<class T>
class AbstractObjectManager {
public:
	//! SigRs[}l[W
	E3DCloneManager m_CloneManager;

	//! tSigIDIuWFNĝ̂擾
	std::map<int, T*> m_mapSigIDToObjectMap;

	//! IuWFNg̎ނƂɃXg쐬
	std::map<int, std::list<T*> > m_mapObjectListMap;

	//! VALIDȃIuWFNĝݓo^BQƂ̂݁BA
	std::map<int, std::list<T*> > m_mapValidObjectListMap;

	BOOL m_bPause;
public:
	AbstractObjectManager() {
		this->m_bPause = FALSE;
	}
	~AbstractObjectManager() {
		for( std::map<int, std::list<T*> >::iterator mit = m_mapObjectListMap.begin();
			mit != m_mapObjectListMap.end();
			mit ++ )
		{
			for( std::list<T*>::iterator it = mit->second.begin();
				it != mit->second.end(); it ++ ) 
			{
				T* t = *it;
				//this->destroyTarget( t );

				
				delete *it;
			}
			mit->second.clear();
		}
		this->m_mapObjectListMap.clear();

		this->m_mapSigIDToObjectMap.clear();
	}


	/** ȀB
	  * BeginScene/EndScene̒ŌĂԎ
	  * etꍇ͂̏̑OɎs
	  *
	  */
	int process() {
		for( std::map<int, std::list<T*> >::iterator mit = this->m_mapObjectListMap.begin();
			mit != this->m_mapObjectListMap.end(); mit ++ )
		{
			//for( std::list<T*>::iterator it = mit->second.begin();
			//	it != mit->second.end(); )
			for( std::list<T*>::iterator it = this->m_mapValidObjectListMap[mit->first].begin();
				it != this->m_mapValidObjectListMap[mit->first].end(); )
			{
				T* obj = *it;

				if( this->is_Skip( obj ) == TRUE ) {
					// skip
					it ++;
					continue;
				}

				int ret = 0;

				// check in
				ret = this->checkInView( obj );

				if( this->m_bPause == FALSE ) {
					// move
					ret = this->move( obj );
					
					// check hit on grund
					ret = this->checkHitToGround( obj );

					// check hit to bill board ( shot )
					ret = this->checkHitToBillBoard( obj );

					// check hit to player
					ret = this->checkHitToPlayer( obj );
				}

				ret = this->render( obj );

				//ret = this->next( obj, it , (*mit ));

				BOOL bIsValid = TRUE;
				try {
					bIsValid = ((HPL::E3D::E3DObject*)obj)->is_Valid();
				} catch( std::exception* e ) {
					e;
				}

				if( bIsValid == FALSE ) {
					it = this->m_mapValidObjectListMap[mit->first].erase(it);
				} else {
					it ++;
				}
			}
		}
		return 0;
	}
	/** Xgɑ΂郊Zbg(ValidSăItɂ)Lq
	  * @retval 0		Ȃ
	  *	@retval	1		肠
	  */
	int reset() {
		int ret = 0;

		for( std::map<int, std::list<T*> >::iterator mit = 
			this->m_mapObjectListMap.begin();
			mit != this->m_mapObjectListMap.end();
		mit ++ )
		{
			this->setInvalidByType( mit->first );
		}
		return 0;
	}

	/** IuWFNgj󂵂܂
	  *
	  */
	void destroyTarget( T* t ) {
		E3DObject* obj = ((E3DObject*)t);

		// IuWFNgւ̎QƂ폜
		this->m_mapObjectListMap.erase(obj->m_nSigID );

		//Q폜܂
		E3DDestroyQ( obj->m_Move.m_nQuoatanion );

		// [VS폜܂
		E3DDestroyAllMotion( obj->m_nSigID );

		// nh폜܂
		E3DDestroyHandlerSet( obj->m_nSigID );
	}


	/** ꕔOăIuWFNg
	  * @param 
	  */
	int destroyAll( int* nExceptList, int nExceptNum) {
		int ret = 0;

		for( std::map<int, std::list<T*> >::iterator mit = 
			this->m_mapObjectListMap.begin();
			mit != this->m_mapObjectListMap.end();
		mit ++ )
		{
			int nType = mit->first;

			bool bIsSkip = false;
			if( nExceptList != NULL ) {
				for(int i = 0; i < nExceptNum; i ++ ) {
					if( nExceptList[i] == mit->first ) {
						bIsSkip = true;
						break;
					}
				}
			}
			if( bIsSkip ) {
				// ZbgɂȂ̂ŁAValidtOZbg
				this->setInvalidByType( nType );

				continue;
			}

			// SIuWFNgɂč폜
			for(std::list<T*>::iterator it = this->m_mapObjectListMap[ nType ].begin();
				it != this->m_mapObjectListMap[ nType ].end();
				it ++ )
			{
				this->destroyTarget( *it );
			}

			// ̎푰̃XgNA
			this->m_mapObjectListMap[nType].clear();

			// ValidNA
			this->m_mapValidObjectListMap[nType].clear();
		}


		return 0;
	}
	
	/** ̎푰̂invalidɂ
	  *
	  */
	void setInvalidByType( int nType ) {
		int ret = 0;
		// LɂȂĂIuWFNgꗗNA
		this->m_mapValidObjectListMap[nType].clear();

		// ̂ValidOFFɂ
		for(std::list<T*>::iterator it = this->m_mapObjectListMap[ nType ].begin();
			it != this->m_mapObjectListMap[ nType ].end();
			it ++ )
		{
			HPL::E3D::E3DObject* obj = (HPL::E3D::E3DObject*)*it;
			this->setInvalidOneObject( obj );
		}
	}

	/** w肵IuWFNgInvalidɂ
	  *
	  */
	void setInvalidOneObject( E3DObject* obj ) {
		int ret = 0;
		if( obj->is_Valid() ) {
			// fB
			ret = E3DSetValidFlag( obj->m_nSigID, -1, FALSE );
		}
		obj->set_Valid( FALSE );
	}

	/** w肵SigIDIuWFNgInvalidɂ
	  *
	  */
	void setInvalidBySigID( int nSigID ) {
		E3DObject* obj = this->m_mapSigIDToObjectMap[nSigID];
		for(std::list<T*>::iterator it = m_mapValidObjectListMap[obj->m_Game.m_nType].begin();
			it != m_mapValidObjectListMap[obj->m_Game.m_nType].end(); )
		{
			E3DObject* target = (E3DObject*)*it;
			if( target->m_nSigID == nSigID ) {
				it = m_mapValidObjectListMap[obj->m_Game.m_nType].erase( it );
			} else {
				it ++;
			}
		}

		this->setInvalidOneObject( obj );
	}
	/** ̃IuWFNg̏XLbv̂ǂ
	  *
	  */
	virtual BOOL is_Skip( T* obj ) = 0;

	/** ViewɃ`FbNC
	  *
	  */
	virtual int checkInView( T* obj ) = 0;

	/** s
	  *
	  */
	virtual int move( T* obj ) = 0;
	
	/** nʂƂ̓蔻
	  * ōsB
	  *
	  */
	virtual int checkHitToGround( T* obj ) = 0;
	
	/** r{[hƂ̓蔻
	  *
	  */
	virtual int checkHitToBillBoard( T* obj ) = 0;
	
	/**  vC[Ƃ̓蔻
	  *
	  */
	virtual int checkHitToPlayer( T* obj ) = 0;
	
	/**  _O
	  *  etꍇ͋ɂ
	  * 
	  */
	virtual int render( T* obj ) = 0;
	
	/** ̗vf֍sƂ̏
	  *
	  */
	//virtual int next( T* obj, std::list<T*>::iterator& it, std::list<T*>& lst ) = 0;

private:
	/** SigIDIuWFNg̋t}bvɓo^
	  *
	  */
	int set_SigIDToObjectMap( int nSigID, T* obj ) {
		this->m_mapSigIDToObjectMap[ nSigID ] = obj;s
	}
protected:
public:
	int get_ValidNum( int nType ) {
		int num = 0;
		for( std::list<T*>::iterator it = this->m_mapObjectListMap[nType].begin();
			it != this->m_mapObjectListMap[nType].end(); it ++ ) {
			E3DObject* obj = ((E3DObject*)*it);
			if( obj->is_Valid()) {
				num ++;
			}
		}
		return num;
	}
	/*std::map<int, std::list<T*> >* get_ObjectListMap() {
		return this->m_mapObjectListMap;
	}
	std::list<T*>* get_ObjectList( int nType ) {
		return &this->m_mapObjectListMap[nType];
	}*/

};
}
}
#endif
