#include "E3DCloneManager.h"
namespace HPL {
namespace E3D {
E3DSigBufferData::E3DSigBufferData() {
	this->m_nBufferSize = 0;
	this->m_lpczBuffer = NULL;
}
E3DSigBufferData::~E3DSigBufferData() {
	if( this->m_lpczBuffer != NULL ) {
		delete this->m_lpczBuffer;
		this->m_lpczBuffer = NULL;
	}
}

E3DCloneManager::E3DCloneManager() {
}
E3DCloneManager::~E3DCloneManager() {
	for( std::map<int, E3DSigBufferData*>::iterator it = this->m_mapMasterBufferMap.begin();
		it != m_mapMasterBufferMap.end();
		it ++ )
	{
		delete it->second;
	}
	this->m_mapMasterBufferMap.clear();
}

/** }X^obt@쐬Aۑ
  * @param[in]	nSigID					ۑSigID
  */
int E3DCloneManager::add_MasterBuffer( int nUserID, int nSigID) {

	int ret = 0;

	// 擾
	E3DSigBufferData* bfBufferData = new E3DSigBufferData();

	ret = E3DSaveSig2Buf( nSigID, NULL, 0, &bfBufferData->m_nBufferSize  );
	bfBufferData->m_lpczBuffer = new char[bfBufferData->m_nBufferSize ];

	ret = E3DSaveSig2Buf( nSigID, bfBufferData->m_lpczBuffer, bfBufferData->m_nBufferSize , &bfBufferData->m_nBufferSize  );
	if(ret || bfBufferData->m_nBufferSize == 0 ) {
		_ASSERT( 0 );
		return 1;
	}

	this->m_mapMasterBufferMap[nUserID] = bfBufferData;
	return 0;
}
E3DSigBufferData* E3DCloneManager::get_MasterBuffer( int nUserID ) {
	return this->m_mapMasterBufferMap[nUserID];
}

void E3DCloneManager::free( int nUserId) {
	delete this->m_mapMasterBufferMap[nUserId];
	this->m_mapMasterBufferMap.erase( nUserId );
}

} // namespace E3D

} // namespace HPL