#include "E3DSigManager.h"

#include "HPLException.h"

namespace HPL {
namespace E3D {

using namespace General;

// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

QuaData::QuaData() : m_nQuaID( 0 ), m_nMaxFrame( 0 ) {
}
QuaData::QuaData( int nQuaID, int nMaxFrame ) : m_nQuaID( nQuaID ), m_nMaxFrame( nMaxFrame ) {
}
QuaData::~QuaData() {
}
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------

SigData::SigData(int nSigID) {
	this->m_nSigID = nSigID;
}
SigData::~SigData() {
	this->m_mapQuaIDMap.clear();
}

/** 
  * @retval		-1					Ɏs
  * @exception	HPLException		݂ID
  */
int SigData::add_Motion( int nUserID, const char* szQuaFilePath, float mvmult) {

	if(this->m_mapQuaIDMap.find( nUserID ) != this->m_mapQuaIDMap.end() ) {
		_ASSERT( 0 );
		throw HPLException( -1, "UserID[%d] is already set", nUserID );
	}

	int nID = -1;
	int nMaxFrame = 0;


	if( E3DAddMotion( this->get_SigID(), 
		szQuaFilePath, mvmult, &nID, &nMaxFrame ) != 0 )
	{
		_ASSERT( 0 );
		return -1;
	}

	QuaData qua( nID, nMaxFrame );

	this->m_mapQuaIDMap[nID] = qua;
	return 0;
}

/** 
  * @retval ꂽID
  */
int SigData::get_SigID() {
	return this->m_nSigID;
}

/** 
  * @retval						QUAf[^
  * @exception HPLException		݂ID
  */
QuaData* SigData::get_Motion( int nUserID) {
	if(this->m_mapQuaIDMap.find( nUserID ) == this->m_mapQuaIDMap.end() ) {
		_ASSERT( 0 );
		throw HPLException( -1, "UserID[%d] not found", nUserID );
	}

	return &this->m_mapQuaIDMap[nUserID];
}


// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
E3DSigManager::E3DSigManager() {
}
E3DSigManager::~E3DSigManager() {
	for(std::map<int, SigData*>::iterator it = this->m_mapSigDataMap.begin();
		it != this->m_mapSigDataMap.end();
		it ++ )
	{
		std::pair<int, SigData*> p = *it;
		delete p.second;
		p.second = NULL;
	}

	this->m_mapSigDataMap.clear();
}

/**
  * @param[in]	szSigFilePath	Sigt@CpX
  * @param[in]	nUserID			[UłID
  * @param[in]	mult			g嗦
  * @retval						Ŏ擾ID
  *				-1				Ɏs
  * @exception	HPLException	ɓo^ĂUserID
  */
int E3DSigManager::load( char* szSigFilePath, int nUserID, float mult ) {
	if( this->m_mapSigDataMap.find( nUserID ) != this->m_mapSigDataMap.end() ) {
		_ASSERT( 0 );
		throw HPLException( -1, "UserID[%d] already set", nUserID);
	}
	int nID = -1;

	if( E3DSigLoad( szSigFilePath, 0, mult, &nID ) != 0 ) {
		_ASSERT( 0 );
		return -1;
	}

	SigData* sig = new SigData(nID);

	this->m_mapSigDataMap[nUserID] = sig;
	return nID;

}

/** 
  * @retval					Ŏ擾ID
  * @exception				݂ȂID
  */
SigData* E3DSigManager::get( int nUserID ) {
	if(this->m_mapSigDataMap.find( nUserID ) == this->m_mapSigDataMap.end() ) {
		_ASSERT( 0 );
		throw HPLException( -1, "UserID[%d] not found", nUserID );
	}

	return this->m_mapSigDataMap[ nUserID ];
}

}
}
