#ifndef _HPL_ROULETTE_SELECTION_
#define _HPL_ROULETTE_SELECTION_

#include <vector>
#include "MathTool.h"

namespace HPLRouletteSelection {

	template<class T>
	int getIndex( std::vector<T>& vecItems ) {
		T nMax = static_cast<T>( 0 );
		for( std::vector<T>::iterator it = vecItems.begin();
			it != vecItems.end(); it ++ )
		{
			if( *it < 0 ) {
				throw;
			}
			nMax += *it;
		}
		int nTrigger = HPL::MathTool::nextRandom<T>(0, nMax );

		for( int nIndex = 0; nIndex < static_cast<int>( vecItems.size() ); nIndex ++ ) {
			nTrigger -= vecItems[nIndex];
			if( nTrigger < 0 ) {
				return nIndex;
			}
		}

		// Xg
		throw;
	}
}

#endif
