#pragma once

typedef class  CXSAnimationKey *XSAnimationKey;

class CXSAnimationKey
{
public:

	char		m_name[256];
	int			m_trans_count;
	int			m_rot_count;

	XSVectorKey		*pTrans;
	XSQuaternionKey	*pRot;

	inline std::string			GetName(void){return (std::string)m_name; };
	inline int				GetVectorKeyCount(void){return m_trans_count; };
	inline int				GetQuaternionKeyCount(void){return m_rot_count; };
	inline XSVectorKey		GetVectorKey(int index){return pTrans[index]; };
	inline XSQuaternionKey	GetQuaternionKey(int index){return pRot[index]; };

	CXSAnimationKey(void){

		pTrans	= NULL;
		pRot	= NULL;
	
	};
	virtual ~CXSAnimationKey(void){

		XS_SAFE_DELETE(pTrans);
		XS_SAFE_DELETE(pRot);

	};

};
