#pragma once

typedef class  CXSMaterial *XSMaterial;

class CXSMaterial
{
public:

	char		m_name[256];
	char		m_tex_name[256];
	char		m_alpha_name[256];
	char		m_bump_name[256];

	MQColor m_color;

	int		m_nVcol;
	int		m_nShader;

	float m_alpha;
	float m_diffuse;
	float m_ambient;
	float m_emission;
	float m_specular;
	float m_power;

	DWORD m_type;

	inline float	GetAlpha(void){ return m_alpha; };
	inline float	GetDiffuse(void){ return m_diffuse; };
	inline float	GetAmbient(void){ return m_ambient; };
	inline float	GetEmission(void){ return m_emission; };
	inline float	GetSpecular(void){ return m_specular; };
	inline float	GetPower(void){ return m_power; };
	inline MQColor	GetColor(void){ return m_color; };
	inline int		GetVertexColor(void){return m_nVcol; };
	inline int		GetShader(void){return m_nShader; };
	inline std::string	GetName(void){return m_name; };
	inline std::string	GetTextureName(void){return m_tex_name; };
	inline std::string	GetAlphaName(void){return m_alpha_name; };
	inline std::string	GetBumpName(void){return m_bump_name; };

	inline DWORD	GetType(void){return m_type; };

	CXSMaterial(void){};
	virtual ~CXSMaterial(void){};

};
