#pragma once

#include "XSFormat.h"

typedef class  CXSMesh *XSMesh;

class CXSMesh
{
public:

	char		m_name[256];
	DWORD		m_type;
	CXSMesh		*pParent;

	int			m_vert_count;
	int			m_face_count;
	int			m_weight_count;

	XSVertex	*pVertex;
	XSFace		*pFace;
	XSWeight	*pWeight;

	inline void			GetName(char *buffer, int size){strncpy(buffer, m_name, size); };
	inline int			GetVertexCount(void){ return m_vert_count; };
	inline MQPoint		GetVertex(int index){ return pVertex[index].point; };
	inline int			GetFaceCount(void){return m_face_count; };
	inline int			GetFacePointCount(int face){ return pFace[face].count; };
	inline void			GetFacePointArray(int face, int *vertex)
						{
							vertex[0] = pFace[face].index[0];
							vertex[1] = pFace[face].index[1];
							vertex[2] = pFace[face].index[2];
							vertex[3] = pFace[face].index[3];
						};
	inline void			GetFaceCoordinateArray(int face, MQCoordinate *uvarray)
						{
							uvarray[0] = pFace[face].uv[0];
							uvarray[1] = pFace[face].uv[1];
							uvarray[2] = pFace[face].uv[2];
							uvarray[3] = pFace[face].uv[3];
						};
	inline int			GetFaceMaterial(int face){ return pFace[face].material; };
	inline MQCoordinate	GetVertexCoord(int index){ return pVertex[index].uv; };
	inline DWORD		GetFaceVertexColor(int face, int vertex){return pFace[face].vcolor[vertex]; };

	inline std::string		GetName(void){return (std::string)m_name; };
	inline XSVertex		GetVertexEx(int index){ return pVertex[index]; };
	inline XSFace		GetFace(int index){ return pFace[index]; };
	inline void			GetFacePointNormals(int face, MQPoint *normals )
						{
							normals[0]=pFace[face].nv[0]; 
							normals[1]=pFace[face].nv[1];
							normals[2]=pFace[face].nv[2];
							normals[3]=pFace[face].nv[3];
						};
	inline MQPoint		GetFaceNormals(int index){return pFace[index].normal; };
	inline MQPoint		GetVertexNormals(int index){return pVertex[index].nv; };
	inline DWORD		GetVertexColor(int index){return pVertex[index].vcolor; };
	inline XSWeight		GetWeight(int index){return pWeight[index]; };
	inline DWORD		GetType(void){return m_type; };

	CXSMesh(void){

		m_name[0]	= '\0';
		m_type		= 0;
		pParent		= NULL;

		pVertex	= NULL;
		pFace	= NULL;
		pWeight = NULL;

	};

	virtual ~CXSMesh(void)
    {
		XS_SAFE_DELETE(pVertex);
		XS_SAFE_DELETE(pFace);
		XS_SAFE_DELETE(pWeight);

	};
};
