#define WIN32_LEAN_AND_MEAN

#include <fstream>
#include <windows.h>
#include <cstdio>
#include <cstdlib>
#include <cstdarg>
#include <ctype.h>
#include <cmath>
#include <Commdlg.h>
#include <ciso646>

#include "RDBPlugin.h"
#include "coef_r.h"
#include "XSFormat.h"
#include "sjis2utf8.h"

#include <crtdbg.h>// <--- _ASSERT}N


static HINSTANCE hInstance;
static HANDLE s_hfile = INVALID_HANDLE_VALUE;

#define BASENUMMAX	100

static int s_basenum = 0;
static RDBMORPHBASE*	s_base = 0;
static RDBMORPHTARGET*	s_target[BASENUMMAX];


//---------------------------------------------------------------------------
//  DllMain
//---------------------------------------------------------------------------
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	//_CAO{bNX̕\ɕKvȂ̂ŁACX^XۑĂ
	hInstance = (HINSTANCE)hModule;


	//ϐ̏
	s_basenum = 0;
	s_base = 0;
	ZeroMemory( s_target, sizeof( RDBMORPHTARGET* ) * BASENUMMAX );

	return TRUE;
}


//---------------------------------------------------------------------------
//  RDBGetPlugInID
//    vOCIDԂB
//    ̊֐͋NɌĂяoB
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT int RDBGetPlugInID(DWORD *Product, DWORD *ID)
{
	// v_Ng(Җ)IDAS64bit̒lƂĕԂ
	// l͑ƏdȂ悤ȃ_Ȃ̂ŗǂ

	char* cproduct;
	cproduct = (char*)Product;
	*cproduct = 't';
	*(cproduct + 1) = 'o';
	*(cproduct + 2) = 'z';
	*(cproduct + 3) = 'i';
	*(cproduct + 4) = 'c';
	*(cproduct + 5) = 'a';

	*ID      = 0xDCBA0023;

	return 0;
}


//---------------------------------------------------------------------------
//  RDBGetPlugInName
//    vOCԂB
//    RokDeBone2̃vOCj[ɁA̖O\B
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT const char* RDBGetPlugInName(void)
{
	// vOC
	return "MQX-Exporter";
}

//---------------------------------------------------------------------------
//  RDBOnClose
//    RokDeBone2I钼ORokDeBone2Ă΂B
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT int RDBOnClose(void)
{
	return 0;
}

//---------------------------------------------------------------------------
//  RDBOnPose
//    RokDeBone2Ń[U[{[̎pҏWA}EX𗣂ƂRokDeBone2Ă΂B
//    [V|Cg͕ύXĂ邪FillUp͂ĂȂԂŌĂ΂B
//---------------------------------------------------------------------------
RDBPLUGIN_EXPORT int RDBOnPose( int motid )
{
	return 0;
}


//----------------------------------------------------------------------------
//  RDBOnSelectPlugin
//  RokDeBone2̃vOCj[ŁARDBGetPlugInName̕IƂɁA
//  ̊֐AAĂ΂܂B
//----------------------------------------------------------------------------

int output(int hsid, int motid);
CXSDocument* makeXSDocument(int hsid, int motid);
void writeMQX(std::ofstream& fo, CXSDocument* doc);

RDBPLUGIN_EXPORT int RDBOnSelectPlugin()
{
	int hsid;
	int ret = 0;

    ret = RDBGetCurrentHSID( &hsid );
	if(hsid >= 0)
    {
        int motid;
        ret = RDBGetCurrentMotID(hsid, &motid);
        if(motid >= 0)
        {
            ret = output(hsid, motid);
            if(ret==0)
            	MessageBox(NULL, "MQX-ExporteȑI܂B", "MQX-Exporter", MB_OK);
        }
        else
        	MessageBox(NULL, "[V܂B", "MQX-Exporter", MB_OK);
	}
    else
    	MessageBox(NULL, "f܂B", "MQX-Exporter", MB_OK);

	return 0;
}


int output(int hsid, int motid)
{
	OPENFILENAME ofn;
	char buf[_MAX_PATH];
	buf[0] = 0;
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = NULL;
	ofn.hInstance = 0;
	ofn.lpstrFilter = (LPCTSTR)"MQX FILE (*.mqx)\0*.mqx\0All Files (*.*)\0*.*\0";
	ofn.lpstrCustomFilter = NULL;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = (LPTSTR)buf;
	ofn.nMaxFile =sizeof(buf);
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.lpstrTitle = NULL;
	ofn.Flags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt ="mqx";
	ofn.lCustData = NULL;
	ofn.lpfnHook = NULL;
	ofn.lpTemplateName = NULL;
	if( GetSaveFileName(&ofn) == 0 )
		return 1;

    std::ofstream fout(ofn.lpstrFile);
	if(not fout)
    {
		RDBDbgOut( "mqx-porter : file open error %s !!!\n", buf );
		_ASSERT( 0 );
		return 1;
	}
    else
    {
        CXSDocument *doc = makeXSDocument(hsid, motid);
        writeMQX(fout, doc);
        delete doc;
    }

    return 0;
}


CXSDocument* makeXSDocument(int hsid, int motid)
{
    CXSDocument *doc = new CXSDocument();
    {
        // RokDeBone f[^擾 CXSDocument \z
    }
    return doc;
}


// UTF8`ɕϊŃt@Cɏ
void write(std::ofstream& fo, std::string str, unsigned indent)
{
    static char disp[256];
    static int size;

    for(int i=0; i<indent; i++)
        str = "    " + str;
    str += '\n';

    /*
    sprintf_s(disp, 256, "%s", str.c_str());
    BYTE* str_utf8;
    sjis2utf8((BYTE*)disp, &str_utf8, &size);
    
    fo.write((char*)disp, size);
    */

    fo << str;

    // delete [] str_utf8;
}


void writeMQX(std::ofstream& fo, CXSDocument* doc)
{
    char line[256];
    write(fo, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", 0);
    write(fo, "<MetasequoiaDocument>", 0);

    write(fo, "<IncludedBy>chara.mqo</IncludedBy>", 1); // f̃t@C
    write(fo, "<Plugin.BD1224DB.0000002C name=\"{[\">", 1);
    write(fo, "<XSFormat version=\"0.2\" app=\"Metasequoia\">", 2);

    write(fo, "<XSConfig>", 3);
    {
        // XSConfig̓e
    }
    write(fo, "</XSConfig>", 3);

    write(fo, "<XSAnimationContainer>", 3);
    {
        // XSAnimationContainer̓e
    }
    write(fo, "</XSAnimationContainer>", 3);

    write(fo, "</XSFormat>", 2);
    write(fo, "</Plugin.BD1224DB.0000002C>", 1);
    write(fo, "</MetasequoiaDocument>", 0);
}

