#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;

#include "CommonFunc.h"
#include "IconManager.h"
#include "Item.h"


namespace MadogenMapEditor {

	namespace FaceDirection{
		enum{
			RIGHT,
			DOWN,
			LEFT,
			UP,
		};
	}
	/// <summary>
	/// ObjectInfo ̊Tv
	///
	/// x: ̃NX̖OύXꍇÃNXˑ邷ׂĂ .resx t@CɊ֘Atꂽ
	///          }l[W \[X RpC c[ɑ΂ 'Resource File Name' vpeB
	///          ύXKv܂B̕ύXsȂƁA
	///          fUCiƁÃtH[Ɋ֘Atꂽ[JCYς݃\[XƂA
	///          ݂ɗpłȂȂ܂B
	/// </summary>
	public ref class ObjectInfo : public System::Windows::Forms::Form
	{
	public:
		ObjectInfo(IconManager^ enemyIconManager, IconManager^ neutralIconManager,
			Form^ parent)
		{
//			m_Palette = paletet;
			bIsLocked = true;
			cli::array<String^>^ ary = CommonFunc::loadFromText( gcnew String(_T("Media/ObjEditor/EnemyNameList.txt")));
			enemyNameList = gcnew ArrayList();
			for each( String^ str in ary ) {
				enemyNameList->Add(str);
			}
			
			ary = CommonFunc::loadFromText( gcnew String(_T("Media/ObjEditor/NeutralNameList.txt")));

			neutralNameList = gcnew ArrayList();
			for each( String^ str in ary ) {
				neutralNameList->Add( str);
			}

			m_EnemyIconList = enemyIconManager;
			m_NeutralIconList = neutralIconManager;

			InitializeComponent();
			//
			//TODO: ɃRXgN^ R[hǉ܂
			//
			this->cmbObjectType->SelectedIndex = 0;

			bIsSelected = false;

			m_Parent = parent;
			bIsLocked = false;

			
		}
	private: System::Windows::Forms::TextBox^  textBox1;
	public: 

	private:
		//Palette^ m_Palette;
		Form^ m_Parent;
	public:
		void select(Item^ item ) {
			this->Name = _T("ObjectInfo *SELECTED*");

			this->bIsSelected = true;
			selectedItem = item;

			// XV
			this->cmbObjectType->SelectedIndex = item->nObjectType;
			setType(item->nType);

			update();
		}
		// ނۂ
		bool bIsLocked;
		void update(){
			bIsLocked = true;
			if( bIsSelected) {
				int nFaceIndex = 0;
				if( selectedItem->nFaceX > 0 && selectedItem->nFaceZ == 0 ) {
					nFaceIndex = FaceDirection::RIGHT;
				} else if(selectedItem->nFaceX == 0 && selectedItem->nFaceZ > 0 ){
					nFaceIndex = FaceDirection::DOWN;
				} else if(selectedItem->nFaceX < 0 && selectedItem->nFaceZ == 0 ) {
					nFaceIndex = FaceDirection::LEFT;
				} else if(selectedItem->nFaceX == 0 && selectedItem->nFaceZ < 0 ){
					nFaceIndex = FaceDirection::UP;
				}
				this->cmbFace->SelectedIndex = nFaceIndex;
				this->numX->Text = Convert::ToString(selectedItem->nX);
				this->numZ->Text = Convert::ToString(-selectedItem->nZ );
				this->numScenario->Text = Convert::ToString(selectedItem->nScenarioIndex);
			}
			bIsLocked = false;
		}
		void unselect(){
			this->Name = _T("ObjectInfo");
			this->bIsSelected = false;
		}
	public:
		bool bIsSelected;
		Item^ selectedItem;

	protected:
		IconManager^ m_EnemyIconList;
		IconManager^ m_NeutralIconList;
	protected:
		ArrayList^ enemyNameList;
	private: System::Windows::Forms::PictureBox^  pictureBox1;
	protected: 
		ArrayList^ neutralNameList;
	protected:
		/// <summary>
		/// gp̃\[XׂăN[Abv܂B
		/// </summary>
		~ObjectInfo()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::Label^  label1;
	private: System::Windows::Forms::ComboBox^  cmbObjectType;
	private: System::Windows::Forms::Label^  label2;
	private: System::Windows::Forms::ComboBox^  cmbType;
	private: System::Windows::Forms::NumericUpDown^  numX;
	private: System::Windows::Forms::NumericUpDown^  numZ;



	private: System::Windows::Forms::Label^  label3;
	private: System::Windows::Forms::Label^  label4;
	private: System::Windows::Forms::ComboBox^  cmbFace;

	private: System::Windows::Forms::Label^  label5;
	private: System::Windows::Forms::NumericUpDown^  numScenario;

	protected: 

	private:
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
			this->label1 = (gcnew System::Windows::Forms::Label());
			this->cmbObjectType = (gcnew System::Windows::Forms::ComboBox());
			this->label2 = (gcnew System::Windows::Forms::Label());
			this->cmbType = (gcnew System::Windows::Forms::ComboBox());
			this->numX = (gcnew System::Windows::Forms::NumericUpDown());
			this->numZ = (gcnew System::Windows::Forms::NumericUpDown());
			this->label3 = (gcnew System::Windows::Forms::Label());
			this->label4 = (gcnew System::Windows::Forms::Label());
			this->cmbFace = (gcnew System::Windows::Forms::ComboBox());
			this->label5 = (gcnew System::Windows::Forms::Label());
			this->numScenario = (gcnew System::Windows::Forms::NumericUpDown());
			this->pictureBox1 = (gcnew System::Windows::Forms::PictureBox());
			this->textBox1 = (gcnew System::Windows::Forms::TextBox());
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numX))->BeginInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numZ))->BeginInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numScenario))->BeginInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->BeginInit();
			this->SuspendLayout();
			// 
			// label1
			// 
			this->label1->AutoSize = true;
			this->label1->Location = System::Drawing::Point(13, 13);
			this->label1->Name = L"label1";
			this->label1->Size = System::Drawing::Size(63, 12);
			this->label1->TabIndex = 0;
			this->label1->Text = L"ObjectType";
			// 
			// cmbObjectType
			// 
			this->cmbObjectType->FormattingEnabled = true;
			this->cmbObjectType->Items->AddRange(gcnew cli::array< System::Object^  >(2) {L"Enemy", L"Neutral"});
			this->cmbObjectType->Location = System::Drawing::Point(82, 10);
			this->cmbObjectType->Name = L"cmbObjectType";
			this->cmbObjectType->Size = System::Drawing::Size(121, 20);
			this->cmbObjectType->TabIndex = 1;
			this->cmbObjectType->SelectedIndexChanged += gcnew System::EventHandler(this, &ObjectInfo::cmbObjectType_SelectedIndexChanged);
			// 
			// label2
			// 
			this->label2->AutoSize = true;
			this->label2->Location = System::Drawing::Point(13, 39);
			this->label2->Name = L"label2";
			this->label2->Size = System::Drawing::Size(30, 12);
			this->label2->TabIndex = 2;
			this->label2->Text = L"Type";
			// 
			// cmbType
			// 
			this->cmbType->FormattingEnabled = true;
			this->cmbType->Location = System::Drawing::Point(82, 36);
			this->cmbType->Name = L"cmbType";
			this->cmbType->Size = System::Drawing::Size(121, 20);
			this->cmbType->TabIndex = 3;
			this->cmbType->SelectedIndexChanged += gcnew System::EventHandler(this, &ObjectInfo::cmbType_SelectedIndexChanged);
			// 
			// numX
			// 
			this->numX->Location = System::Drawing::Point(82, 63);
			this->numX->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
			this->numX->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, System::Int32::MinValue});
			this->numX->Name = L"numX";
			this->numX->Size = System::Drawing::Size(120, 19);
			this->numX->TabIndex = 4;
			this->numX->ValueChanged += gcnew System::EventHandler(this, &ObjectInfo::numX_ValueChanged);
			// 
			// numZ
			// 
			this->numZ->Location = System::Drawing::Point(82, 89);
			this->numZ->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
			this->numZ->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, System::Int32::MinValue});
			this->numZ->Name = L"numZ";
			this->numZ->Size = System::Drawing::Size(120, 19);
			this->numZ->TabIndex = 5;
			this->numZ->ValueChanged += gcnew System::EventHandler(this, &ObjectInfo::numZ_ValueChanged);
			// 
			// label3
			// 
			this->label3->AutoSize = true;
			this->label3->Location = System::Drawing::Point(13, 65);
			this->label3->Name = L"label3";
			this->label3->Size = System::Drawing::Size(24, 12);
			this->label3->TabIndex = 6;
			this->label3->Text = L"Pos";
			// 
			// label4
			// 
			this->label4->AutoSize = true;
			this->label4->Location = System::Drawing::Point(13, 118);
			this->label4->Name = L"label4";
			this->label4->Size = System::Drawing::Size(30, 12);
			this->label4->TabIndex = 7;
			this->label4->Text = L"Face";
			// 
			// cmbFace
			// 
			this->cmbFace->FormattingEnabled = true;
			this->cmbFace->Items->AddRange(gcnew cli::array< System::Object^  >(4) {L"", L"", L"", L""});
			this->cmbFace->Location = System::Drawing::Point(82, 115);
			this->cmbFace->Name = L"cmbFace";
			this->cmbFace->Size = System::Drawing::Size(121, 20);
			this->cmbFace->TabIndex = 8;
			this->cmbFace->Text = L"";
			this->cmbFace->SelectedIndexChanged += gcnew System::EventHandler(this, &ObjectInfo::cmbFace_SelectedIndexChanged);
			// 
			// label5
			// 
			this->label5->AutoSize = true;
			this->label5->Location = System::Drawing::Point(13, 144);
			this->label5->Name = L"label5";
			this->label5->Size = System::Drawing::Size(60, 12);
			this->label5->TabIndex = 9;
			this->label5->Text = L"ScenarioID";
			// 
			// numScenario
			// 
			this->numScenario->Location = System::Drawing::Point(82, 142);
			this->numScenario->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
			this->numScenario->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {1, 0, 0, System::Int32::MinValue});
			this->numScenario->Name = L"numScenario";
			this->numScenario->Size = System::Drawing::Size(120, 19);
			this->numScenario->TabIndex = 10;
			this->numScenario->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) {1, 0, 0, System::Int32::MinValue});
			this->numScenario->ValueChanged += gcnew System::EventHandler(this, &ObjectInfo::numScenario_ValueChanged);
			// 
			// pictureBox1
			// 
			this->pictureBox1->Location = System::Drawing::Point(225, 65);
			this->pictureBox1->Name = L"pictureBox1";
			this->pictureBox1->Size = System::Drawing::Size(40, 40);
			this->pictureBox1->TabIndex = 11;
			this->pictureBox1->TabStop = false;
			// 
			// textBox1
			// 
			this->textBox1->Location = System::Drawing::Point(15, 167);
			this->textBox1->Multiline = true;
			this->textBox1->Name = L"textBox1";
			this->textBox1->ScrollBars = System::Windows::Forms::ScrollBars::Both;
			this->textBox1->Size = System::Drawing::Size(420, 165);
			this->textBox1->TabIndex = 12;
			// 
			// ObjectInfo
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(447, 344);
			this->ControlBox = false;
			this->Controls->Add(this->textBox1);
			this->Controls->Add(this->pictureBox1);
			this->Controls->Add(this->numScenario);
			this->Controls->Add(this->label5);
			this->Controls->Add(this->cmbFace);
			this->Controls->Add(this->label4);
			this->Controls->Add(this->label3);
			this->Controls->Add(this->numZ);
			this->Controls->Add(this->numX);
			this->Controls->Add(this->cmbType);
			this->Controls->Add(this->label2);
			this->Controls->Add(this->cmbObjectType);
			this->Controls->Add(this->label1);
			this->Name = L"ObjectInfo";
			this->ShowInTaskbar = false;
			this->Text = L"ObjectInfo";
			this->TopMost = true;
			this->Load += gcnew System::EventHandler(this, &ObjectInfo::ObjectInfo_Load);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numX))->EndInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numZ))->EndInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numScenario))->EndInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion
		private: System::Void updateParent(){
					 this->m_Parent->Refresh();
				 }
				 public: void setObjectType( int index ) {
							 this->cmbObjectType->SelectedIndex = index;
						 }
				 public: void setTypeIndex(int index ){
							 this->cmbType->SelectedIndex = index;
						 }
	private: System::Void ObjectInfo_Load(System::Object^  sender, System::EventArgs^  e) {
			 }
private: System::Void cmbObjectType_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
			 setType( 0);
			 //m_Palette->nSelectObjectType = cmbObjectType->SelectedIndex;
			// m_Palette->nSelectType = cmbType->SelectedIndex;

		 }
private: System::Void cmbType_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
			// ACRI
			 Image^ img;
			 int nType = this->cmbType->SelectedIndex;
			 if( this->cmbObjectType->SelectedIndex == ObjectType::ENEMY ) {
				 img = m_EnemyIconList->get(nType );
			 } else if( this->cmbObjectType->SelectedIndex == ObjectType::NEUTRAL ) {
				 img = m_NeutralIconList->get( nType );
			 }
			 pictureBox1->Image = img;
			 this->Refresh();

			 //m_Palette->nSelectType = cmbType->SelectedIndex;
			// m_Palette->Refresh();
		 }
		 private: System::Void setType( int nDefaultSelectIndex ) {
					 this->cmbType->Items->Clear();

					 ArrayList^ aryList;

					 if( this->cmbObjectType->SelectedIndex == ObjectType::ENEMY ) {
						 aryList = enemyNameList ;

					 } else if( this->cmbObjectType->SelectedIndex == ObjectType::NEUTRAL ) {
						 aryList = neutralNameList ;
					 } else {
						 MessageBox::Show(_T("Invalid ObjectType"));
					 }
					 for each(String^ str in aryList ) {
						 this->cmbType->Items->Add(str);
					 }

					 this->cmbType->SelectedIndex = nDefaultSelectIndex;
				  }

private: System::Void numX_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
			
		 }
private: System::Void numZ_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
		 }
private: System::Void cmbFace_SelectedIndexChanged(System::Object^  sender, System::EventArgs^  e) {
		 }
private: System::Void numScenario_ValueChanged(System::Object^  sender, System::EventArgs^  e) {
			 if( bIsSelected ) {
				 selectedItem->nScenarioIndex = Convert::ToInt32(this->numScenario->Value );
			 }
		 }
};
}
