#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;

#include "IconManager.h"
#include "Item.h"
#include "ObjectInfo.h"
#include "Mode.h"

namespace MadogenMapEditor {


	const int MERGINE_BETWEEN_ENEMY_AND_NEUTRAL = 5;

	/// <summary>
	/// Palette ̊Tv
	///
	/// x: ̃NX̖OύXꍇÃNXˑ邷ׂĂ .resx t@CɊ֘Atꂽ
	///          }l[W \[X RpC c[ɑ΂ 'Resource File Name' vpeB
	///          ύXKv܂B̕ύXsȂƁA
	///          fUCiƁÃtH[Ɋ֘Atꂽ[JCYς݃\[XƂA
	///          ݂ɗpłȂȂ܂B
	/// </summary>
	public ref class Palette : public System::Windows::Forms::Form
	{
	public:
		Palette()
		{
			InitializeComponent();
			//
			//TODO: ɃRXgN^ R[hǉ܂
			//
			enemyIconManager = gcnew IconManager(gcnew String(_T("Media/ObjEditor/EnemyIconList.txt")));
			neutralIconManager = gcnew IconManager(gcnew String(_T("Media/ObjEditor/NeutralIconList.txt")));
			nSelectObjectType = ObjectType::ENEMY;
			nSelectType = 0;

			selectImage = System::Drawing::Image::FromFile(_T("Media/ObjEditor/Cursor.png"));
		}
		void setForm(ObjectInfo^ objInfo, Mode^ mode){
			m_ObjectInfo = objInfo;
			m_Mode = mode;
		}

	public:
		Mode^ m_Mode;
		ObjectInfo^ m_ObjectInfo;
		Image^ selectImage;
		IconManager^ enemyIconManager;
		IconManager^ neutralIconManager;
		int nSelectObjectType;
		int nSelectType;
	protected:
		/// <summary>
		/// gp̃\[XׂăN[Abv܂B
		/// </summary>
		~Palette()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::PictureBox^  pictureBox1;
	protected: 

	private:
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
			this->pictureBox1 = (gcnew System::Windows::Forms::PictureBox());
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->BeginInit();
			this->SuspendLayout();
			// 
			// pictureBox1
			// 
			this->pictureBox1->Dock = System::Windows::Forms::DockStyle::Fill;
			this->pictureBox1->Location = System::Drawing::Point(0, 0);
			this->pictureBox1->Name = L"pictureBox1";
			this->pictureBox1->Size = System::Drawing::Size(405, 99);
			this->pictureBox1->TabIndex = 0;
			this->pictureBox1->TabStop = false;
			this->pictureBox1->MouseClick += gcnew System::Windows::Forms::MouseEventHandler(this, &Palette::pictureBox1_MouseClick);
			this->pictureBox1->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Palette::pictureBox1_Paint);
			// 
			// Palette
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->AutoValidate = System::Windows::Forms::AutoValidate::EnablePreventFocusChange;
			this->ClientSize = System::Drawing::Size(405, 99);
			this->ControlBox = false;
			this->Controls->Add(this->pictureBox1);
			this->DoubleBuffered = true;
			this->Name = L"Palette";
			this->ShowInTaskbar = false;
			this->Text = L"Palette";
			this->TopMost = true;
			this->Load += gcnew System::EventHandler(this, &Palette::Palette_Load);
			this->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Palette::Palette_Paint);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->EndInit();
			this->ResumeLayout(false);

		}
#pragma endregion
	private: System::Void pictureBox1_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e) {
				 
				 Bitmap^ bitmap = gcnew Bitmap( this->pictureBox1->Size.Width,
					 this->pictureBox1->Size.Height );

				 Graphics^ g = Graphics::FromImage( bitmap );

				 int counter = 0;
				 for each(Object^ obj in enemyIconManager->imageList ) {
					 
					 Image^ img = (Image^)obj;
					
					 int x = counter * img->Width;
					 int y = 0;

					 g->DrawImage(img, x, y );

					 if( nSelectObjectType == ObjectType::ENEMY &&
						 nSelectType == counter )
					 {
						 g->DrawImage( selectImage, x, y);
					 }


					 counter ++;
				 }

				 counter = 0;
				 for each(Object^ obj in neutralIconManager->imageList ) {
					 Image^ img = (Image^)obj;
					 int x = counter * img->Width;
					 int y = img->Height + MERGINE_BETWEEN_ENEMY_AND_NEUTRAL;

					 g->DrawImage(img, x, y );

					 if( nSelectObjectType == ObjectType::NEUTRAL &&
						 nSelectType == counter )
					 {
						 g->DrawImage( selectImage, x, y);
					 }
					 counter ++;
				 }


				 e->Graphics->DrawImage( bitmap, g->VisibleClipBounds );
			 }
private: System::Void pictureBox1_MouseClick(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {
				 int counter = 0;
				 bool bSelected = false;
				 for each(Object^ obj in enemyIconManager->imageList ) {
					 
					 Image^ img = (Image^)obj;
					
					 int x = counter * img->Width;
					 int y = 0;

					 if( e->X >= x && e->X <= x + img->Width &&
						 e->Y >= y && e->Y <= y + img->Height )
					 {
						 nSelectObjectType = ObjectType::ENEMY;
						 nSelectType = counter;
						 bSelected = true;

						 break;
					 }


					 counter ++;
				 }

				 if( bSelected == false ) {
					 counter = 0;

					 for each(Object^ obj in neutralIconManager->imageList ) {
						 Image^ img = (Image^)obj;
						 int x = counter * img->Width;
						 int y = img->Height + MERGINE_BETWEEN_ENEMY_AND_NEUTRAL;

						 if(  e->X >= x && e->X <= x + img->Width &&
							 e->Y >= y && e->Y <= y + img->Height )
						 {
							 nSelectObjectType = ObjectType::NEUTRAL;
							 nSelectType = counter;
							 bSelected = true;
							 break;
						 }
						 counter ++;
					 }
				 }
				 if( bSelected){

					 if( m_ObjectInfo->bIsSelected == false) {
						 m_ObjectInfo->setObjectType( nSelectObjectType );
						 m_ObjectInfo->setTypeIndex( nSelectType );
					 }

					 m_Mode->nMode = ModeType::CREATE;
					 m_Mode->Refresh();
					 m_Mode->button1->BackColor = Color::White;
					 m_Mode->button2->BackColor = Color::Gray;
					 m_Mode->button3->BackColor = Color::White;
				 }
				 this->Refresh();
		 }
private: System::Void Palette_Load(System::Object^  sender, System::EventArgs^  e) {
			this->SetStyle( ControlStyles::DoubleBuffer, true);
			this->SetStyle( ControlStyles::UserPaint, true);
			this->SetStyle( ControlStyles::AllPaintingInWmPaint, true);
		 }
private: System::Void Palette_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e) {
				 this->pictureBox1->Refresh();
		 }
};
}
